/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh.jsch;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.ssh.SshConnectionException;
import org.echocat.jomon.net.ssh.SshRemote;
import org.echocat.jomon.net.ssh.SshSession;
import org.echocat.jomon.net.ssh.SshSessionGenerator;
import org.echocat.jomon.net.ssh.SshSessionRequirement;
import org.echocat.jomon.net.ssh.jsch.JschSshSession;

public abstract class JschSshSessionGeneratorSupport
implements SshSessionGenerator {
    @Nonnull
    public SshSession generate(@Nonnull SshSessionRequirement requirement) {
        requirement.getRemote();
        JSch jsch = this.createJsch(requirement);
        this.configureJsch(jsch, requirement);
        Session session = this.createSessionBy(jsch, requirement);
        this.configureSession(session, requirement);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new SshConnectionException("Could not connect to " + requirement.getRemote() + ".", e);
        }
        return new JschSshSession(requirement.getRemote(), session);
    }

    @Nonnull
    protected Session createSessionBy(@Nonnull JSch jsch, @Nonnull SshSessionRequirement requirement) {
        SshRemote remote = requirement.getRemote();
        InetSocketAddress address = remote.getAddress();
        try {
            return jsch.getSession(remote.getUser(), address.getHostName(), address.getPort());
        }
        catch (JSchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Nonnull
    protected JSch createJsch(@Nonnull SshSessionRequirement requirement) {
        return new JSch();
    }

    protected void configureJsch(@Nonnull JSch jsch, @Nonnull SshSessionRequirement requirement) {
        IdentityRepository identityRepository = this.createIdentityRepository(requirement);
        jsch.setIdentityRepository(identityRepository);
    }

    protected void configureSession(@Nonnull Session session, @Nonnull SshSessionRequirement requirement) {
        session.setUserInfo((UserInfo)new NoopUserInfo());
    }

    @Nonnull
    protected abstract IdentityRepository createIdentityRepository(@Nonnull SshSessionRequirement var1);

    protected static class NoopUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        protected NoopUserInfo() {
        }

        public String getPassword() {
            return null;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            return new String[0];
        }
    }
}

