/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.spring.BeanFactoryUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextUtils {
    private ApplicationContextUtils() {
    }

    @Nullable
    public static Class<?> findTypeOfBeanDefinition(@Nonnull ApplicationContext applicationContext, @Nonnull String beanName) {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalArgumentException("Currently there is only an applicationContext of type " + ConfigurableApplicationContext.class.getName() + " supported.");
        }
        return ApplicationContextUtils.findTypeOfBeanDefinition((ConfigurableApplicationContext)applicationContext, beanName);
    }

    @Nullable
    public static Class<?> findTypeOfBeanDefinition(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull String beanName) {
        return BeanFactoryUtils.findTypeOfBeanDefinition(applicationContext.getBeanFactory(), beanName);
    }

    @Nullable
    public static String findScopeOfBeanDefinition(@Nonnull ApplicationContext applicationContext, @Nonnull String beanName) {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalArgumentException("Currently there is only an applicationContext of type " + ConfigurableApplicationContext.class.getName() + " supported.");
        }
        return ApplicationContextUtils.findScopeOfBeanDefinition((ConfigurableApplicationContext)applicationContext, beanName);
    }

    @Nullable
    public static String findScopeOfBeanDefinition(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull String beanName) {
        return BeanFactoryUtils.findScopeOfBeanDefinition(applicationContext.getBeanFactory(), beanName);
    }
}

