/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.util.ArrayList;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.spring.application.Application;
import org.echocat.jomon.spring.application.ApplicationGenerator;
import org.echocat.jomon.spring.application.ApplicationRequirement;
import org.echocat.jomon.spring.application.DefaultApplicationGenerator;

public class ApplicationGenerators {
    @Nonnull
    private static final Iterable<ApplicationGenerator> ALL = ApplicationGenerators.loadAll();
    @Nonnull
    private static final ApplicationGenerator DEFAULT = new Combined();

    private ApplicationGenerators() {
    }

    @Nonnull
    public static ApplicationGenerator getDefault() {
        return DEFAULT;
    }

    @Nonnull
    public static ApplicationGenerator applicationGenerator() {
        return ApplicationGenerators.getDefault();
    }

    @Nonnull
    public static Iterable<ApplicationGenerator> getAll() {
        return ALL;
    }

    @Nonnull
    private static Iterable<ApplicationGenerator> loadAll() {
        ArrayList<DefaultApplicationGenerator> result = new ArrayList<DefaultApplicationGenerator>();
        CollectionUtils.addAll(result, ServiceLoader.load(ApplicationGenerator.class));
        result.add(new DefaultApplicationGenerator());
        return CollectionUtils.asImmutableList(result);
    }

    private static class Combined
    implements ApplicationGenerator {
        private Combined() {
        }

        @Nonnull
        public Application generate(@Nonnull ApplicationRequirement requirement) {
            Application result = null;
            for (ApplicationGenerator generator : ALL) {
                if (!generator.supports(requirement)) continue;
                result = (Application)generator.generate(requirement);
            }
            if (result == null) {
                throw new IllegalArgumentException("Could not generate application for " + requirement + ".");
            }
            return result;
        }

        @Override
        public boolean supports(@Nonnull ApplicationRequirement requirement) {
            boolean result = false;
            for (ApplicationGenerator generator : ALL) {
                if (!generator.supports(requirement)) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

