/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.concurrent.StopWatch;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ResourceUtils;
import org.echocat.jomon.spring.application.Application;
import org.echocat.jomon.spring.application.ApplicationInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

@ThreadSafe
public class DefaultApplication
implements Application {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplication.class);
    @Nonnull
    private final ConfigurableApplicationContext _applicationContext;
    @Nonnull
    private final ApplicationInformation _information;
    @Nonnull
    private final LoggingEnvironment _loggingEnvironment;
    @Nonnull
    private final Thread _shutdownHook;
    @Nullable
    private StopWatch _stopWatch;

    public DefaultApplication(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull ApplicationInformation information, @Nonnull LoggingEnvironment loggingEnvironment) {
        this._applicationContext = applicationContext;
        this._information = information;
        this._loggingEnvironment = loggingEnvironment;
        this._shutdownHook = new Thread(this.getTitle() + " destroyer"){

            @Override
            public void run() {
                ResourceUtils.closeQuietly((AutoCloseable)DefaultApplication.this);
            }
        };
        if (applicationContext instanceof AbstractApplicationContext) {
            this.setShutdownHook(this._shutdownHook, (AbstractApplicationContext)applicationContext);
        }
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        DefaultApplication defaultApplication = this;
        synchronized (defaultApplication) {
            if (!this._applicationContext.isActive()) {
                this._applicationContext.refresh();
                this._stopWatch = new StopWatch();
            }
        }
    }

    @Override
    @Nonnull
    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    @Override
    @Nonnull
    public ApplicationInformation getInformation() {
        return this._information;
    }

    @Override
    @Nonnull
    public LoggingEnvironment getLoggingEnvironment() {
        return this._loggingEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        DefaultApplication defaultApplication = this;
        synchronized (defaultApplication) {
            try {
                try {
                    try {
                        if (this._applicationContext.isActive()) {
                            Duration uptime = this.getUptime();
                            LOG.info("Stopping " + this.getTitle() + (uptime != null ? " (was up for: " + uptime.toPattern(TimeUnit.MILLISECONDS) + ")" : "") + "...");
                            StopWatch stopWatch = new StopWatch();
                            ((DisposableBean)this._applicationContext).destroy();
                            LOG.info("Stopping " + this.getTitle() + "... DONE! (after: " + stopWatch.toCurrentPattern(TimeUnit.MILLISECONDS) + ")");
                        }
                    }
                    finally {
                        this._stopWatch = null;
                    }
                }
                finally {
                    Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
                }
            }
            finally {
                ResourceUtils.closeQuietly((AutoCloseable)this._loggingEnvironment);
            }
        }
    }

    @Nonnull
    protected String getTitle() {
        return this.getInformation().getTitle();
    }

    public String toString() {
        return this.getTitle();
    }

    protected void setShutdownHook(@Nonnull Thread thread, @Nonnull AbstractApplicationContext to) {
        try {
            Field field = AbstractApplicationContext.class.getDeclaredField("shutdownHook");
            field.setAccessible(true);
            field.set(to, thread);
        }
        catch (Exception e) {
            LOG.warn("Could not register shutdownHook at " + to + " this could cause to much memory consume of the JVM.", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public Duration getUptime() {
        StopWatch stopWatch = this._stopWatch;
        return stopWatch != null ? stopWatch.getCurrentDuration() : null;
    }
}

