/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.spring.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.ManifestInformationFactory;
import org.echocat.jomon.spring.application.ApplicationContextRequirement;
import org.echocat.jomon.spring.application.ApplicationInformation;
import org.echocat.jomon.spring.application.ApplicationInformationGenerator;
import org.echocat.jomon.spring.application.ApplicationInformationGenerators;
import org.echocat.jomon.spring.application.ApplicationInformationRequirement;
import org.echocat.jomon.spring.application.JavaBasedApplicationContextRequirement;
import org.echocat.jomon.spring.application.XmlBasedApplicationContextRequirement;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ManifestBasedApplicationInformationGenerator
implements ApplicationInformationGenerator {
    @Override
    public boolean supports(@Nonnull ApplicationInformationRequirement requirement) {
        return this.tryGenerateFor(requirement.getApplicationContextRequirement()) != null;
    }

    @Nonnull
    public ApplicationInformation generate(@Nonnull ApplicationInformationRequirement requirement) {
        ApplicationInformation information = this.tryGenerateFor(requirement.getApplicationContextRequirement());
        return information != null ? information : new ApplicationInformationGenerators.FallbackInformation();
    }

    @Nullable
    protected ApplicationInformation tryGenerateFor(@Nonnull ApplicationContextRequirement applicationContextRequirement) {
        ApplicationInformation result = applicationContextRequirement instanceof XmlBasedApplicationContextRequirement ? this.tryGenerateFor((XmlBasedApplicationContextRequirement)applicationContextRequirement) : (applicationContextRequirement instanceof JavaBasedApplicationContextRequirement ? this.generateFor((JavaBasedApplicationContextRequirement)applicationContextRequirement) : null);
        return result;
    }

    @Nullable
    protected ApplicationInformation tryGenerateFor(@Nonnull XmlBasedApplicationContextRequirement configuration) {
        ApplicationInformation result = null;
        for (Resource resource : configuration.getConfigurationFiles()) {
            String path;
            ClassLoader classLoader;
            if (resource instanceof ClassPathResource && (result = this.tryGenerateFor(classLoader = ((ClassPathResource)resource).getClassLoader(), path = ((ClassPathResource)resource).getPath())) != null) break;
        }
        return result;
    }

    @Nonnull
    protected ApplicationInformation generateFor(@Nonnull JavaBasedApplicationContextRequirement configuration) {
        Class<?> aClass;
        ApplicationInformation result = null;
        Iterator<Class<?>> iterator = configuration.getClasses().iterator();
        while (iterator.hasNext() && (result = this.tryGenerateFor(aClass = iterator.next())) == null) {
        }
        return result;
    }

    @Nullable
    protected ApplicationInformation tryGenerateFor(@Nonnull ClassLoader classLoader, @Nonnull String referenceResource) {
        ManifestInformationFactory factory = new ManifestInformationFactory(referenceResource, classLoader);
        return StringUtils.isEmpty((CharSequence)factory.getImplementationTitle()) ? null : new ManifestInformation(factory);
    }

    @Nullable
    protected ApplicationInformation tryGenerateFor(@Nonnull Class<?> type) {
        ManifestInformationFactory factory = new ManifestInformationFactory(type);
        return StringUtils.isEmpty((CharSequence)factory.getImplementationTitle()) ? null : new ManifestInformation(factory);
    }

    protected static class ManifestInformation
    implements ApplicationInformation {
        @Nonnull
        private final ManifestInformationFactory _factory;

        public ManifestInformation(@Nonnull ManifestInformationFactory factory) {
            this._factory = factory;
        }

        @Override
        @Nullable
        public String getBanner() {
            String string;
            String bannerFile = this._factory.getImplementationBannerFile();
            if (!StringUtils.isEmpty((CharSequence)bannerFile)) {
                try (InputStream is = this._factory.getClassLoader().getResourceAsStream(bannerFile);){
                    String result;
                    if (is != null) {
                        result = IOUtils.toString((InputStream)is);
                    }
                    result = null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read banner file '" + bannerFile + "'.", e);
                }
            } else {
                string = null;
            }
            return string;
        }

        @Override
        @Nonnull
        public String getTitle() {
            return this._factory.getApplicationInfoString();
        }

        @Override
        @Nullable
        public String getName() {
            return this._factory.getImplementationTitle();
        }

        @Override
        @Nullable
        public String getVersion() {
            return this._factory.getImplementationVersion();
        }

        @Override
        @Nullable
        public String getBuildRevision() {
            return this._factory.getImplementationBuildRevision();
        }

        @Override
        @Nullable
        public String getBuildDate() {
            return this._factory.getImplementationBuildDate();
        }
    }
}

