/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.cache;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.InMemoryBasedCacheSupport;
import org.echocat.jomon.cache.LocalTrackingEnabledCacheListener;
import org.echocat.jomon.cache.LruCache;
import org.echocat.jomon.cache.management.CacheRepository;
import org.echocat.jomon.net.cluster.channel.HandlerEnabledClusterChannel;
import org.echocat.jomon.net.cluster.channel.Message;
import org.echocat.jomon.runtime.math.OverPeriodCounter;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.ValueProducer;

public abstract class CacheListenerForClusterChannelSupport
implements LocalTrackingEnabledCacheListener,
AutoCloseable {
    public static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private final ThreadLocal<Boolean> _inHandleMessage = new ThreadLocal();
    private final CacheRepository _cacheRepository;
    private final HandlerEnabledClusterChannel<?, ?> _clusterChannel;
    private final InMemoryBasedCacheSupport<ReportKey, ReportImpl> _localTrackingCache;
    private volatile boolean _trackLocalEventsEnabled;

    public CacheListenerForClusterChannelSupport(@Nonnull CacheRepository cacheRepository, @Nonnull HandlerEnabledClusterChannel<?, ?> clusterChannel) {
        this._cacheRepository = cacheRepository;
        this._clusterChannel = clusterChannel;
        this._localTrackingCache = this.createCache();
    }

    @Nonnull
    private InMemoryBasedCacheSupport<ReportKey, ReportImpl> createCache() {
        LruCache cache = new LruCache(ReportKey.class, ReportImpl.class);
        cache.setCapacity(Long.valueOf(0L));
        return cache;
    }

    public void setNumberOfLocalTrackedEvents(int numberOfLocalTrackedEvents) {
        this._localTrackingCache.setCapacity(Long.valueOf(numberOfLocalTrackedEvents));
        this._trackLocalEventsEnabled = numberOfLocalTrackedEvents > 0;
    }

    public int getNumberOfLocalTrackedEvents() {
        return this._localTrackingCache.getCapacity().intValue();
    }

    @Nonnull
    public Collection<? extends LocalTrackingEnabledCacheListener.Report> getReports() {
        TreeSet<ReportImpl> reports = new TreeSet<ReportImpl>();
        for (ReportKey reportKey : this._localTrackingCache) {
            ReportImpl report = (ReportImpl)this._localTrackingCache.get((Object)reportKey);
            reports.add(report);
        }
        return Collections.unmodifiableCollection(reports);
    }

    protected void record(final @Nonnull LocalTrackingEnabledCacheListener.Event event) {
        if (this._trackLocalEventsEnabled) {
            final StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            ReportImpl report = (ReportImpl)this._localTrackingCache.get((Object)new ReportKey(event, stackTrace), (ValueProducer)new ValueProducer<ReportKey, ReportImpl>(){

                public ReportImpl produce(@Nullable ReportKey key) throws Exception {
                    return new ReportImpl(event, stackTrace);
                }
            });
            report.hit();
        }
    }

    @Nonnull
    protected abstract HandlerEnabledClusterChannel.MessageHandler getMessageHandler();

    protected boolean isInHandleMessage() {
        return Boolean.TRUE == this._inHandleMessage.get();
    }

    protected boolean isPossibleEndlessLoop() {
        return this.isInHandleMessage();
    }

    protected void startHandleMessage() {
        this._inHandleMessage.set(Boolean.TRUE);
    }

    protected void finishHandleMessage() {
        this._inHandleMessage.remove();
    }

    @Nonnull
    protected ThreadLocal<Boolean> getInHandleMessage() {
        return this._inHandleMessage;
    }

    @Nonnull
    protected CacheRepository getCacheRepository() {
        return this._cacheRepository;
    }

    @Nonnull
    protected HandlerEnabledClusterChannel<?, ?> getClusterChannel() {
        return this._clusterChannel;
    }

    @PostConstruct
    public void init() throws Exception {
        this._clusterChannel.register(this.getMessageHandler());
    }

    @Override
    @PreDestroy
    public void close() throws Exception {
        this._clusterChannel.unregister(this.getMessageHandler());
    }

    public void send(@Nonnull Message message) throws IllegalArgumentException {
        this._clusterChannel.send(message);
    }

    public void send(@Nonnull Message message, @Nonnegative long timeout, @Nonnull TimeUnit unit) throws IllegalArgumentException {
        this._clusterChannel.send(message, timeout, unit);
    }

    @Nullable
    public <K, V> Cache<K, V> findCache(@Nonnull String id) {
        return this._cacheRepository.find(id);
    }

    @Nonnull
    protected String getLogStackTracePropertyName() {
        return this.getClass().getName() + ".logStackTrace";
    }

    protected boolean isLogStackTrace() {
        String plainValue = System.getProperty(this.getLogStackTracePropertyName(), Boolean.FALSE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(plainValue);
    }

    @Nullable
    protected Throwable createThrowableIfLogStackTraceIsNeeded() {
        return this.isLogStackTrace() ? new Throwable() : null;
    }

    protected static class ReportImpl
    implements LocalTrackingEnabledCacheListener.Report,
    Comparable<LocalTrackingEnabledCacheListener.Report> {
        private final AtomicLong _numberOfInvocations = new AtomicLong();
        private final OverPeriodCounter _numberOfInvocationsPerSecond = new OverPeriodCounter(new Duration("1m"), new Duration("1s"));
        @Nonnull
        private final LocalTrackingEnabledCacheListener.Event _event;
        private final StackTraceElement[] _stackTrace;

        public ReportImpl(@Nonnull LocalTrackingEnabledCacheListener.Event event, @Nonnull StackTraceElement[] stackTrace) {
            this._event = event;
            this._stackTrace = stackTrace;
        }

        protected void hit() {
            this._numberOfInvocations.incrementAndGet();
            this._numberOfInvocationsPerSecond.record();
        }

        @Nonnull
        public LocalTrackingEnabledCacheListener.Event getEvent() {
            return this._event;
        }

        @Nonnegative
        public long getNumberOfInvocations() {
            return this._numberOfInvocations.get();
        }

        @Nonnegative
        public double getNumberOfInvocationsPerSecond() {
            return this._numberOfInvocationsPerSecond.getAsDouble();
        }

        @Nonnull
        public StackTraceElement[] getStackTrace() {
            return this._stackTrace;
        }

        @Override
        public int compareTo(@Nullable LocalTrackingEnabledCacheListener.Report to) {
            int result = to == null ? 1 : Double.compare(this.getNumberOfInvocationsPerSecond(), to.getNumberOfInvocationsPerSecond()) * -1;
            return result;
        }
    }

    protected static class ReportKey {
        private final LocalTrackingEnabledCacheListener.Event _event;
        private final StackTraceElement[] _stackTrace;

        public ReportKey(@Nonnull LocalTrackingEnabledCacheListener.Event event, @Nonnull StackTraceElement[] stackTrace) {
            this._event = event;
            this._stackTrace = stackTrace;
        }

        public boolean equals(Object o) {
            boolean result;
            if (this == o) {
                result = true;
            } else if (!(o instanceof ReportKey)) {
                result = false;
            } else {
                ReportKey that = (ReportKey)o;
                result = this._event.equals(that._event) && Arrays.equals(this._stackTrace, that._stackTrace);
            }
            return result;
        }

        public int hashCode() {
            return 31 * this._event.hashCode() + Arrays.hashCode(this._stackTrace);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._event);
            for (StackTraceElement stackTraceElement : this._stackTrace) {
                sb.append("\n\tat ").append(stackTraceElement);
            }
            return sb.toString();
        }
    }
}

