/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.cluster.channel.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.cluster.channel.tcp.RemoteTcpNode;
import org.echocat.jomon.runtime.util.ResourceUtils;

public class OutboundTcpNode
extends RemoteTcpNode {
    private final OutputStream _outputStream;
    private final Runnable _onClose;

    public OutboundTcpNode(@Nonnull UUID id, @Nonnull Socket socket, @Nonnull OutputStream outputStream) throws IOException {
        this(id, socket, outputStream, null);
    }

    public OutboundTcpNode(@Nonnull UUID id, @Nonnull Socket socket, @Nonnull OutputStream outputStream, @Nullable Runnable onClose) throws IOException {
        super(id, socket);
        this._outputStream = outputStream;
        this._onClose = onClose;
    }

    @Nonnull
    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._onClose != null) {
                this._onClose.run();
            }
        }
        finally {
            try {
                ResourceUtils.closeQuietly((AutoCloseable)this._outputStream);
            }
            finally {
                super.close();
            }
        }
    }
}

