/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.NetworkInterfaceUtils;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.numbers.IntegerRange;

public class FreeTcpPortDetector {
    public static final int DEFAULT_MIN_PORT = 10000;
    public static final int DEFAULT_MAX_PORT = 45000;
    @Nonnull
    private final Random _random = new Random();
    @Nonnull
    private final InetAddress _address;
    @Nonnegative
    @Including
    private final int _from;
    @Nonnegative
    @Excluding
    private final int _to;
    @Nonnegative
    private final int _range;

    public FreeTcpPortDetector(@Nonnull NetworkInterface networkInterface, @Including @Nonnegative int minPort, @Excluding @Nonnegative int maxPort) {
        this(NetworkInterfaceUtils.getFirstAddressOf(networkInterface), minPort, maxPort);
    }

    public FreeTcpPortDetector(@Nonnull InetAddress address, @Including @Nonnegative int minPort, @Excluding @Nonnegative int maxPort) {
        if (minPort > maxPort) {
            throw new IllegalArgumentException("The maxPort have to larger than or equal to the minPort.");
        }
        this._address = address;
        this._from = minPort;
        this._to = maxPort;
        this._range = maxPort - minPort;
    }

    public FreeTcpPortDetector(@Nonnull NetworkInterface networkInterface, @Nullable IntegerRange portRange) {
        this(NetworkInterfaceUtils.getFirstAddressOf(networkInterface), portRange);
    }

    public FreeTcpPortDetector(@Nonnull InetAddress address, @Nullable IntegerRange portRange) {
        this._address = address;
        this._from = portRange != null ? (Integer)portRange.getFrom((Object)10000) : 10000;
        this._to = portRange != null ? (Integer)portRange.getTo((Object)45000) : 45000;
        this._range = this._to - this._from;
    }

    @Nonnegative
    public int detect() throws NoSuchElementException {
        HashSet<Integer> alreadyTriedPorts = new HashSet<Integer>();
        int tries = 0;
        Integer port = null;
        while (port == null && tries <= this._range) {
            int currentPort = this._range > 0 ? this._random.nextInt(this._to - this._from) + this._from : this._from;
            if (alreadyTriedPorts.contains(currentPort)) continue;
            ++tries;
            alreadyTriedPorts.add(currentPort);
            try {
                ServerSocket socket = new ServerSocket();
                socket.bind(new InetSocketAddress(this._address, currentPort));
                socket.close();
                port = currentPort;
            }
            catch (BindException ignored) {
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find a free port on '" + this._address + "' between ports " + this._from + " and " + this._to + ".", e);
            }
        }
        if (port == null) {
            throw new NoSuchElementException("Could not find a free port on '" + this._address + "' between ports " + this._from + " and " + this._to + ".");
        }
        return port;
    }
}

