/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net;

import com.google.common.base.Predicate;
import java.net.NetworkInterface;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.NetworkInterfaceType;
import org.echocat.jomon.runtime.repository.Query;

public class NetworkInterfaceQuery
implements Query,
Predicate<NetworkInterface> {
    @Nullable
    private NetworkInterfaceType _type;
    @Nullable
    private Pattern _namePattern;

    @Nonnull
    public static NetworkInterfaceQuery networkInterface() {
        return new NetworkInterfaceQuery();
    }

    @Nonnull
    public NetworkInterfaceQuery whichIsOfType(@Nullable NetworkInterfaceType type) {
        this._type = type;
        return this;
    }

    @Nonnull
    public NetworkInterfaceQuery withNameMatches(@Nullable Pattern pattern) {
        this._namePattern = pattern;
        return this;
    }

    @Nonnull
    public NetworkInterfaceQuery withName(@Nullable String name) {
        return this.withNameMatches(name != null ? Pattern.compile(Pattern.quote(name)) : null);
    }

    @Nullable
    public NetworkInterfaceType getType() {
        return this._type;
    }

    @Nullable
    public Pattern getNamePattern() {
        return this._namePattern;
    }

    public boolean apply(@Nullable NetworkInterface input) {
        return input != null && this.applyType(input) && this.applyName(input);
    }

    protected boolean applyType(@Nonnull NetworkInterface of) {
        return this._type == null || this._type == NetworkInterfaceType.typeOf(of);
    }

    protected boolean applyName(@Nonnull NetworkInterface of) {
        return this._namePattern == null || this._namePattern.matcher(of.getName()).matches();
    }
}

