/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.dns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import org.echocat.jomon.net.FreeTcpPortDetector;
import org.echocat.jomon.net.dns.DnsServer;

public class TemporaryDnsServer
extends DnsServer {
    private final InetSocketAddress _address;

    public TemporaryDnsServer() {
        super("");
        try {
            this._address = TemporaryDnsServer.getFreeLocalHostSocketAddress();
            this.addTCP(this._address);
            this.addUDP(this._address);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server.", e);
        }
    }

    @Nonnull
    private static InetSocketAddress getFreeLocalHostSocketAddress() throws IOException {
        InetAddress localHostAddress = TemporaryDnsServer.getLocalHostAddress();
        int port = TemporaryDnsServer.getFreePort(localHostAddress);
        return new InetSocketAddress(localHostAddress, port);
    }

    @Nonnull
    private static InetAddress getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    private static int getFreePort(@Nonnull InetAddress localHostAddress) throws IOException {
        FreeTcpPortDetector detector = new FreeTcpPortDetector(localHostAddress, 10000, 45000);
        return detector.detect();
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        return this._address;
    }
}

