/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import com.google.common.base.Predicate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.process.Process;
import org.echocat.jomon.runtime.repository.Query;
import org.echocat.jomon.runtime.util.Glob;

public abstract class ProcessQuery<E, ID, T extends ProcessQuery<E, ID, T>>
implements Query,
Predicate<Process<E, ID>> {
    private List<ID> _ids;
    private E _executable;
    private Glob _commandLineGlob;

    @Nonnull
    public T withId(@Nonnull ID id) {
        return this.withIds(id);
    }

    @Nonnull
    public T withIds(ID ... ids) {
        return this.withIds(Arrays.asList(ids));
    }

    @Nonnull
    public T withIds(@Nonnull Iterable<ID> ids) {
        ArrayList<ID> idsAsList = new ArrayList<ID>();
        for (ID id : ids) {
            idsAsList.add(id);
        }
        return this.withIds((List<ID>)idsAsList);
    }

    @Nonnull
    public T withIds(@Nonnull List<ID> ids) {
        if (this._ids != null) {
            throw new IllegalStateException("Ids already set.");
        }
        this._ids = ids;
        return this.thisObject();
    }

    @Nonnull
    public T withExecutable(@Nonnull E executable) {
        if (this._executable != null) {
            throw new IllegalStateException("Executable already set.");
        }
        this._executable = executable;
        return this.thisObject();
    }

    @Nonnull
    public T withCommandLineLike(@Nonnull String commandLineGlobPattern) {
        try {
            return this.withCommandLineLike(new Glob(commandLineGlobPattern));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal pattern: " + commandLineGlobPattern, e);
        }
    }

    @Nonnull
    public T withCommandLineLike(@Nonnull Glob commandLine) {
        if (this._commandLineGlob != null) {
            throw new IllegalStateException("Executable already set.");
        }
        this._commandLineGlob = commandLine;
        return this.thisObject();
    }

    @Nullable
    public List<ID> getIds() {
        return this._ids;
    }

    @Nullable
    public E getExecutable() {
        return this._executable;
    }

    @Nullable
    public Glob getCommandLineGlob() {
        return this._commandLineGlob;
    }

    public boolean apply(@Nullable Process<E, ID> input) {
        return input != null && this.applyId(input) && this.applyExecutable(input) && this.applyCommandLine(input);
    }

    protected boolean applyId(@Nonnull Process<E, ID> process) {
        return this._ids == null || this._ids.contains(process.getId());
    }

    protected boolean applyExecutable(@Nonnull Process<E, ID> process) {
        return this._executable == null || this._executable.equals(process.getExecutable());
    }

    protected boolean applyCommandLine(@Nonnull Process<E, ID> process) {
        boolean result;
        if (this._commandLineGlob == null) {
            result = true;
        } else {
            List<String> arguments = process.getArguments();
            if (arguments != null) {
                String joinedCommandLine = StringUtils.join(arguments, (char)' ');
                result = this._commandLineGlob.matches(joinedCommandLine);
            } else {
                result = false;
            }
        }
        return result;
    }

    @Nonnull
    protected T thisObject() {
        return (T)this;
    }
}

