/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.listeners.stream;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.GeneratedProcess;
import org.echocat.jomon.process.listeners.stream.LineBasedAndStateEnabledStreamListenerSupport;
import org.echocat.jomon.process.listeners.stream.LineBasedStreamListenerSupport;
import org.echocat.jomon.process.listeners.stream.StreamListenerProviderSupport;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.io.StreamType;
import org.echocat.jomon.runtime.logging.LogLevel;
import org.echocat.jomon.runtime.logging.Slf4jUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectToLoggerStreamListener<P extends GeneratedProcess<?, ?>>
extends LineBasedAndStateEnabledStreamListenerSupport<P, RedirectToLoggerStreamListener<P>> {
    @Nonnull
    public static final Map<StreamType, LogLevel> DEFAULT_STREAM_TYPE_TO_LOG_LEVEL = CollectionUtils.asImmutableMap((Object[])new Object[]{StreamType.stdout, LogLevel.info, StreamType.stderr, LogLevel.error, StreamType.system, LogLevel.info});
    @Nonnull
    private final Map<StreamType, LogLevel> _streamTypeToLogLevel = new HashMap<StreamType, LogLevel>(DEFAULT_STREAM_TYPE_TO_LOG_LEVEL);
    @Nonnull
    private final Logger _logger;

    public RedirectToLoggerStreamListener() {
        this((Logger)null);
    }

    public RedirectToLoggerStreamListener(@Nullable Class<?> clazz) {
        this(clazz != null ? LoggerFactory.getLogger(clazz) : null);
    }

    public RedirectToLoggerStreamListener(@Nullable String loggerName) {
        this(loggerName != null ? LoggerFactory.getLogger((String)loggerName) : null);
    }

    public RedirectToLoggerStreamListener(@Nullable Logger logger) {
        this._logger = logger != null ? logger : LoggerFactory.getLogger(RedirectToLoggerStreamListener.class);
        this.whichFormatsMessagesWith("{message}");
    }

    @Nonnull
    public RedirectToLoggerStreamListener<P> whichLogsStreamTypeOn(@Nonnull StreamType streamType, @Nonnull LogLevel on) {
        this._streamTypeToLogLevel.put(streamType, on);
        return this;
    }

    @Nonnull
    public LogLevel getLogLevelFor(@Nonnull StreamType streamType) {
        LogLevel logLevel = this._streamTypeToLogLevel.get(streamType);
        if (logLevel == null) {
            throw new IllegalArgumentException("Could not handle streamType: " + streamType);
        }
        return logLevel;
    }

    @Nonnull
    public Map<StreamType, LogLevel> getStreamTypeToLogLevel() {
        return CollectionUtils.asImmutableMap(this._streamTypeToLogLevel);
    }

    @Override
    protected void write(@Nonnull P process, @Nonnull String content, @Nonnull StreamType streamType) {
        String line = this.removeLastLineBreakFrom(content);
        LogLevel logLevel = this.getLogLevelFor(streamType);
        Slf4jUtils.log((Logger)this._logger, (LogLevel)logLevel, (String)line);
    }

    @Nonnull
    protected String getDisplayFor(@Nonnull P reference) {
        Object plain = reference.getId();
        return plain != null ? plain.toString() : "<unknown>";
    }

    public static class Provider
    extends StreamListenerProviderSupport {
        public Provider() {
            super(RedirectToLoggerStreamListener.class, "redirectToLogger", new String[0]);
        }

        @Override
        @Nonnull
        protected LineBasedStreamListenerSupport<?, ?> createInstanceBy(@Nonnull Class<? extends LineBasedStreamListenerSupport<?, ?>> type, @Nonnull Map<String, String> parameters) {
            return new RedirectToLoggerStreamListener();
        }
    }
}

