/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.local;

import java.io.File;
import javax.annotation.Nonnull;
import org.echocat.jomon.process.BaseGeneratedProcessRequirement;

public class LocalGeneratedProcessRequirement
extends BaseGeneratedProcessRequirement<File, LocalGeneratedProcessRequirement> {
    @Nonnull
    public static LocalGeneratedProcessRequirement process(@Nonnull File executable) {
        return new LocalGeneratedProcessRequirement(executable);
    }

    @Nonnull
    public static LocalGeneratedProcessRequirement process(@Nonnull String executable) {
        return new LocalGeneratedProcessRequirement(executable);
    }

    public LocalGeneratedProcessRequirement(@Nonnull File executable) {
        super(executable);
        this.withWorkingDirectory(System.getProperty("user.dir", "."));
    }

    public LocalGeneratedProcessRequirement(@Nonnull String executable) {
        this(new File(executable));
    }

    @Override
    @Nonnull
    public LocalGeneratedProcessRequirement withWorkingDirectory(@Nonnull File workingDirectory) {
        if (!workingDirectory.isDirectory()) {
            throw new IllegalArgumentException(workingDirectory + " does not exist.");
        }
        return (LocalGeneratedProcessRequirement)super.withWorkingDirectory(workingDirectory);
    }

    @Override
    @Nonnull
    public LocalGeneratedProcessRequirement withWorkingDirectory(@Nonnull String workingDirectory) {
        return this.withWorkingDirectory(new File(workingDirectory));
    }

    @Override
    @Nonnull
    public File getWorkingDirectory() {
        return (File)super.getWorkingDirectory();
    }
}

