/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.ssh;

import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.ssh.SshContext;
import org.echocat.jomon.net.ssh.SshRemote;
import org.echocat.jomon.process.BaseGeneratedProcessRequirement;
import org.echocat.jomon.process.Pty;

public class SshGeneratedProcessRequirement
extends BaseGeneratedProcessRequirement<String, SshGeneratedProcessRequirement> {
    @Nonnull
    private final SshContext _context;
    @Nullable
    private Pty _pty;
    private boolean _agentForwarding = true;

    @Nonnull
    public static SshGeneratedProcessRequirement process(@Nonnull String remote, @Nonnull String executable) {
        return SshGeneratedProcessRequirement.process(SshRemote.Impl.remote(remote), executable);
    }

    @Nonnull
    public static SshGeneratedProcessRequirement process(@Nonnull InetSocketAddress address, @Nullable String user, @Nullable String password, @Nonnull String executable) {
        return SshGeneratedProcessRequirement.process(SshRemote.Impl.remote(address, user, password), executable);
    }

    @Nonnull
    public static SshGeneratedProcessRequirement process(@Nonnull InetSocketAddress address, @Nullable String user, @Nonnull String executable) {
        return SshGeneratedProcessRequirement.process(address, user, null, executable);
    }

    @Nonnull
    public static SshGeneratedProcessRequirement process(@Nonnull InetSocketAddress address, @Nonnull String executable) {
        return SshGeneratedProcessRequirement.process(address, null, executable);
    }

    @Nonnull
    public static SshGeneratedProcessRequirement process(@Nonnull SshContext context, @Nonnull String executable) {
        return new SshGeneratedProcessRequirement(context, executable);
    }

    public SshGeneratedProcessRequirement(@Nonnull SshContext context, @Nonnull String executable) {
        super((Object)executable);
        this._context = context;
    }

    @Nonnull
    public SshGeneratedProcessRequirement withPty(@Nullable Pty pty) {
        this._pty = pty;
        return (SshGeneratedProcessRequirement)this.thisObject();
    }

    @Nonnull
    public SshGeneratedProcessRequirement withAgentForwarding(boolean agentForwarding) {
        this._agentForwarding = agentForwarding;
        return (SshGeneratedProcessRequirement)this.thisObject();
    }

    @Nonnull
    public SshGeneratedProcessRequirement withAgentForwarding() {
        return this.withAgentForwarding(true);
    }

    @Nonnull
    public SshGeneratedProcessRequirement withoutAgentForwarding() {
        return this.withAgentForwarding(false);
    }

    @Nonnull
    public SshGeneratedProcessRequirement with(@Nullable Pty pty) {
        return this.withPty(pty);
    }

    @Nonnull
    public SshContext getContext() {
        return this._context;
    }

    @Nullable
    public Pty getPty() {
        return this._pty;
    }

    public boolean isAgentForwarding() {
        return this._agentForwarding;
    }

    public String toString() {
        return this.getContext() + ": " + super.toString();
    }
}

