/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.testing.environments;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;

public class LogbackTemporaryLogAppender
extends ExternalResource {
    @Nonnull
    private final LoggingEnvironment _loggingEnvironment;
    @Nonnull
    private final String _forLogger;
    @Nonnull
    private final ListAppender<ILoggingEvent> _temporaryAppender = new ListAppender();

    public LogbackTemporaryLogAppender(@Nonnull LoggingEnvironment loggingEnvironment, @Nonnull Class<?> forLogger) {
        this(loggingEnvironment, forLogger.getName());
    }

    public LogbackTemporaryLogAppender(@Nonnull LoggingEnvironment loggingEnvironment, @Nonnull String forLogger) {
        this._loggingEnvironment = loggingEnvironment;
        this._forLogger = forLogger;
        Logger loggerInstance = this.getSlf4jLogger();
        if (!ch.qos.logback.classic.Logger.class.isInstance(loggerInstance)) {
            throw new UnsupportedOperationException("Logger instance '" + loggerInstance + "' not supported at the moment. Only instances of " + ch.qos.logback.classic.Logger.class + " are supported, yet.");
        }
    }

    protected void before() throws Throwable {
        this._temporaryAppender.start();
        this.getLogbackLogger().addAppender(this._temporaryAppender);
    }

    protected void after() {
        this._temporaryAppender.stop();
        try {
            this.getLogbackLogger().detachAppender(this._temporaryAppender);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nonnull
    private ch.qos.logback.classic.Logger getLogbackLogger() {
        return (ch.qos.logback.classic.Logger)this.getSlf4jLogger();
    }

    @Nonnull
    private Logger getSlf4jLogger() {
        return this._loggingEnvironment.getLogger(this._forLogger);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList loggingEvents = new ArrayList(this._temporaryAppender.list);
        for (ILoggingEvent loggingEvent : loggingEvents) {
            sb.append(loggingEvent).append("\n");
        }
        return sb.toString();
    }
}

