/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.format.Formatter;
import org.echocat.jomon.format.FormatterSupport;
import org.echocat.jomon.format.Source;
import org.echocat.jomon.format.Target;
import org.echocat.jomon.runtime.util.Hints;

@ThreadSafe
@Immutable
public class CombinedFormatter
extends FormatterSupport {
    private static final CombinedFormatter INSTANCE = new CombinedFormatter();
    @Nonnull
    private final List<Formatter> _delegates;

    @Nonnull
    public static Formatter formatter() {
        return INSTANCE;
    }

    @Nonnull
    public static List<Formatter> getSystemFormatters(@Nullable ClassLoader classLoader) {
        ServiceLoader<Formatter> formatters = classLoader != null ? ServiceLoader.load(Formatter.class, classLoader) : ServiceLoader.load(Formatter.class);
        ArrayList<Formatter> result = new ArrayList<Formatter>();
        for (Formatter formatter : formatters) {
            result.add(formatter);
        }
        return Collections.unmodifiableList(result);
    }

    public CombinedFormatter(@Nullable List<Formatter> delegates) {
        this._delegates = delegates != null ? delegates : Collections.emptyList();
    }

    public CombinedFormatter(@Nullable ClassLoader classLoader) {
        this(CombinedFormatter.getSystemFormatters(classLoader));
    }

    public CombinedFormatter() {
        this((ClassLoader)null);
    }

    @Override
    public void format(@Nonnull Source source, @Nonnull Target target, @Nullable Hints hints) throws IllegalArgumentException, IOException {
        for (Formatter delegate : this._delegates) {
            if (!delegate.canHandle(source, target, hints)) continue;
            delegate.format(source, target, hints);
        }
    }

    @Override
    public boolean canHandle(@Nonnull Source source, @Nonnull Target target, @Nullable Hints hints) {
        boolean result = false;
        for (Formatter delegate : this._delegates) {
            if (!delegate.canHandle(source, target, hints)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nonnull
    public List<Formatter> getDelegates() {
        return this._delegates;
    }
}

