/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.mail;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.net.mail.Mail;
import org.echocat.jomon.net.mail.MailSender;
import org.echocat.jomon.runtime.concurrent.RetryForSpecifiedCountStrategy;
import org.echocat.jomon.runtime.concurrent.Retryer;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingMailSender
implements MailSender {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingMailSender.class);
    private static final RetryingStrategy<Void> DEFAULT_RETRYING_STRATEGY = RetryForSpecifiedCountStrategy.retryForSpecifiedCountOf((int)5).withExceptionsThatForceRetry(new Class[]{MailSender.MailSenderException.class});
    private final MailSender _delegate;
    private final MailSender _fallback;
    private RetryingStrategy<Void> _retryingStrategy = DEFAULT_RETRYING_STRATEGY;
    private boolean _logWarnIfFallbackIsUsed;

    public RetryingMailSender(@Nonnull MailSender delegate) {
        this(delegate, null);
    }

    public RetryingMailSender(@Nonnull MailSender delegate, @Nullable MailSender fallback) {
        this._delegate = delegate;
        this._fallback = fallback;
    }

    public void setRetryingStrategy(@Nonnull RetryingStrategy<Void> retryingStrategy) {
        this._retryingStrategy = retryingStrategy;
    }

    public void setLogWarnIfFallbackIsUsed(boolean logWarnIfFallbackIsUsed) {
        this._logWarnIfFallbackIsUsed = logWarnIfFallbackIsUsed;
    }

    @Override
    public void send(final @Nonnull Mail mail) throws MailSender.MailSenderException {
        try {
            Retryer.executeWithRetry((Runnable)new Runnable(){

                @Override
                public void run() {
                    RetryingMailSender.this._delegate.send(mail);
                }
            }, this._retryingStrategy, MailSender.MailSenderException.class);
        }
        catch (MailSender.MailSenderException e) {
            if (this._fallback != null) {
                if (this._logWarnIfFallbackIsUsed) {
                    LOG.warn("Could not send " + mail + " with " + this._delegate + " after several retries (based on " + this._retryingStrategy + "). Please check the following exception. Will now fallback to " + this._fallback + ".", (Throwable)e);
                }
                this._fallback.send(mail);
            }
            throw e;
        }
    }
}

