/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import com.Ostermiller.util.MD5OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.MemoryResource;
import org.echocat.jomon.resources.NameEnabledMemoryResource;
import org.echocat.jomon.resources.NameEnabledResource;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceGenerator;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.UriEnabledResource;

@NotThreadSafe
public class MemoryResourceGenerator
extends ResourceGenerator {
    private final ByteArrayOutputStream _outputStream;
    private final MD5OutputStream _md5OutputStream;

    public MemoryResourceGenerator(@Nonnull Resource originalResource) throws IOException {
        this(originalResource, null);
    }

    public MemoryResourceGenerator(@Nonnull Resource originalResource, @Nullable String name) throws IOException {
        this(originalResource.getType(), originalResource, name);
    }

    public MemoryResourceGenerator(@Nonnull ResourceType type) throws IOException {
        this(type, null);
    }

    public MemoryResourceGenerator(@Nonnull ResourceType type, @Nullable String name) throws IOException {
        this(type, null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryResourceGenerator(@Nonnull ResourceType type, @Nullable Resource originalResource, @Nullable String name) throws IOException {
        super(type, originalResource, name);
        boolean success = false;
        this._outputStream = new ByteArrayOutputStream();
        try {
            this._md5OutputStream = new MD5OutputStream((OutputStream)this._outputStream);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((OutputStream)this._outputStream);
            }
        }
    }

    @Override
    protected MemoryResource generateResource() throws IOException {
        byte[] md5 = this._md5OutputStream.getHash();
        MemoryResource result = this.getName() != null ? new NameEnabledMemoryResource(this._outputStream.toByteArray(), md5, this.getType(), this.getName(), true) : (this.getOriginalResource() instanceof NameEnabledResource ? new NameEnabledMemoryResource(this._outputStream.toByteArray(), md5, this.getType(), ((NameEnabledResource)this.getOriginalResource()).getName(), true) : (this.getOriginalResource() instanceof UriEnabledResource ? new NameEnabledMemoryResource(this._outputStream.toByteArray(), md5, this.getType(), ((UriEnabledResource)this.getOriginalResource()).getUri(), true) : new MemoryResource(this._outputStream.toByteArray(), md5, this.getType(), true)));
        return result;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this._md5OutputStream;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.closeQuietly((OutputStream)this._md5OutputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this._outputStream);
        }
    }
}

