/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.PrivateUrlEnabledResource;
import org.echocat.jomon.resources.ResourceSupport;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.UriEnabledResource;

public class UriResource
extends ResourceSupport
implements UriEnabledResource,
PrivateUrlEnabledResource {
    private final URI _uri;
    private final Path _path;
    private final ResourceType _resourceType;
    private final boolean _generated;

    public UriResource(@Nonnull URI uri, @Nonnull ResourceType resourceType, boolean generated) {
        this._uri = uri;
        this._resourceType = resourceType;
        this._generated = generated;
        this._path = Paths.get(uri);
    }

    @Override
    @Nonnull
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this._path, new OpenOption[0]);
    }

    @Override
    @Nonnull
    public ResourceType getType() throws IOException {
        return this._resourceType;
    }

    @Override
    public long getSize() throws IOException {
        return Files.size(this._path);
    }

    @Override
    public Date getLastModified() throws IOException {
        return new Date(Files.getLastModifiedTime(this._path, new LinkOption[0]).toMillis());
    }

    @Override
    public boolean isExisting() throws IOException {
        return Files.exists(this._path, new LinkOption[0]);
    }

    @Override
    public boolean isGenerated() throws IOException {
        return this._generated;
    }

    @Override
    @Nonnull
    public String getUri() {
        return this._uri.toString();
    }

    @Override
    @Nonnull
    public URL getPrivateUrl() throws IOException {
        return this._uri.toURL();
    }
}

