/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.optimizing.CachedResourcesOptimizer;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.ResourceOptimizer;
import org.echocat.jomon.resources.optimizing.ResourcesOptimizer;

public class CombinedResourcesOptimizer
extends CachedResourcesOptimizer {
    private final Iterable<ResourceOptimizer> _resourceOptimizers;
    private Set<ResourceType> _types;
    private Iterable<ResourcesOptimizer> _preResourcesOptimizers;
    private Iterable<ResourcesOptimizer> _postResourcesOptimizers;

    public CombinedResourcesOptimizer(@Nonnull Iterable<ResourceOptimizer> resourceOptimizers, @Nonnull CacheProvider cacheProvider) {
        super(cacheProvider);
        this._resourceOptimizers = resourceOptimizers;
        this.rebuildTypes();
    }

    public Iterable<ResourcesOptimizer> getPreResourcesOptimizers() {
        return this._preResourcesOptimizers;
    }

    public void setPreResourcesOptimizers(Iterable<ResourcesOptimizer> preResourcesOptimizers) {
        this._preResourcesOptimizers = preResourcesOptimizers;
        this.rebuildTypes();
    }

    public Iterable<ResourcesOptimizer> getPostResourcesOptimizers() {
        return this._postResourcesOptimizers;
    }

    public void setPostResourcesOptimizers(Iterable<ResourcesOptimizer> postResourcesOptimizers) {
        this._postResourcesOptimizers = postResourcesOptimizers;
        this.rebuildTypes();
    }

    @Override
    @Nonnull
    public Collection<Resource> optimizeIfAbsent(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        Collection<Resource> preProcessed = this.preProcess(inputs, context);
        Collection<Resource> processed = this.process(preProcessed, context);
        Collection<Resource> postProcessed = this.postProcess(processed, context);
        return postProcessed;
    }

    @Override
    public boolean isSupporting(@Nonnull ResourceType type) {
        return this._types.contains(type);
    }

    @Override
    @Nonnull
    public Set<ResourceType> getSupportedResourceTypes() {
        return Collections.unmodifiableSet(this._types);
    }

    @Nonnull
    protected Collection<Resource> preProcess(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        Collection<Resource> outputs = inputs;
        if (this._preResourcesOptimizers != null) {
            for (ResourcesOptimizer preResourcesOptimizer : this._preResourcesOptimizers) {
                outputs = preResourcesOptimizer.optimize(outputs, context);
            }
        }
        return outputs;
    }

    @Nonnull
    protected Collection<Resource> process(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        ArrayList<Resource> outputs = new ArrayList<Resource>();
        Iterator<Resource> iterator = inputs.iterator();
        while (iterator.hasNext()) {
            Resource input;
            Resource resource = input = iterator.next();
            for (ResourceOptimizer resourceOptimizer : this._resourceOptimizers) {
                if (!resourceOptimizer.isSupporting(resource.getType())) continue;
                resource = resourceOptimizer.optimize(resource, context);
            }
            outputs.add(resource);
        }
        return outputs;
    }

    @Nonnull
    protected Collection<Resource> postProcess(@Nonnull Collection<Resource> inputs, @Nonnull OptimizationContext context) throws Exception {
        Collection<Resource> outputs = inputs;
        if (this._postResourcesOptimizers != null) {
            for (ResourcesOptimizer postResourcesOptimizer : this._postResourcesOptimizers) {
                outputs = postResourcesOptimizer.optimize(outputs, context);
            }
        }
        return outputs;
    }

    protected void rebuildTypes() {
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        for (ResourceOptimizer resourceOptimizer : this._resourceOptimizers) {
            types.addAll(resourceOptimizer.getSupportedResourceTypes());
        }
        if (this._preResourcesOptimizers != null) {
            for (ResourcesOptimizer preResourcesOptimizer : this._preResourcesOptimizers) {
                types.addAll(preResourcesOptimizer.getSupportedResourceTypes());
            }
        }
        if (this._postResourcesOptimizers != null) {
            for (ResourcesOptimizer postResourcesOptimizer : this._postResourcesOptimizers) {
                types.addAll(postResourcesOptimizer.getSupportedResourceTypes());
            }
        }
        this._types = types;
    }
}

