/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.resources.PathBasedResourceProvider;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceRequestUriGenerator;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.ResourcesOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizationContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizationContextFactory.class);
    private final ResourcesOptimizer _optimizer;
    private final PathBasedResourceProvider<Resource> _resourceProvider;
    private final ResourceRequestUriGenerator _resourceRequestUriGenerator;

    public OptimizationContextFactory(@Nonnull ResourcesOptimizer optimizer, @Nonnull PathBasedResourceProvider<Resource> resourceProvider, @Nonnull ResourceRequestUriGenerator resourceRequestUriGenerator) {
        this._optimizer = optimizer;
        this._resourceProvider = resourceProvider;
        this._resourceRequestUriGenerator = resourceRequestUriGenerator;
    }

    @Nonnull
    public OptimizationContext create(OptimizationContext.Feature ... withFeatures) {
        return this.create(withFeatures != null ? Arrays.asList(withFeatures) : null);
    }

    @Nonnull
    public OptimizationContext create(@Nullable Iterable<OptimizationContext.Feature> withFeatures) {
        OptimizationContextImpl context = new OptimizationContextImpl();
        if (withFeatures != null) {
            for (OptimizationContext.Feature withFeature : withFeatures) {
                if (withFeature == null) continue;
                context.setFeature(withFeature, true);
            }
        }
        return context;
    }

    @ThreadSafe
    protected class OptimizationContextImpl
    implements OptimizationContext {
        private final Map<OptimizationContext.Feature, Boolean> _features = Collections.synchronizedMap(new HashMap());

        protected OptimizationContextImpl() {
        }

        @Override
        public boolean isFeatureEnabled(@Nonnull OptimizationContext.Feature feature) {
            return Boolean.TRUE.equals(this._features.get(feature));
        }

        @Override
        public void setFeature(@Nonnull OptimizationContext.Feature feature, boolean enabled) {
            this._features.put(feature, enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public Set<OptimizationContext.Feature> getFeatures() {
            HashSet<OptimizationContext.Feature> features = new HashSet<OptimizationContext.Feature>();
            Map<OptimizationContext.Feature, Boolean> map = this._features;
            synchronized (map) {
                for (Map.Entry<OptimizationContext.Feature, Boolean> entry : this._features.entrySet()) {
                    if (!Boolean.TRUE.equals(entry.getValue())) continue;
                    features.add(entry.getKey());
                }
            }
            return Collections.unmodifiableSet(features);
        }

        @Override
        @Nonnull
        public Resource optimize(@Nonnull Resource input) throws Exception {
            Resource output;
            Collection<Resource> outputs = this.optimize(Collections.singletonList(input));
            if (Iterables.isEmpty(outputs)) {
                LOG.warn("This resource " + input + " could not be optimized by " + OptimizationContextFactory.this._optimizer + ". The optimizer returned no results. This will return the original one. This could cause other problems but we hope that this will help. Check the configuration of you optimizers to prevent this problem in the future.");
                output = input;
            } else if (outputs.size() == 1) {
                output = outputs.iterator().next();
            } else {
                LOG.warn("This resource " + input + " could not be optimized by " + OptimizationContextFactory.this._optimizer + ". The optimizer returned " + outputs.size() + " results. This will return the original one. This could cause other problems but we hope that this will help. Check the configuration of you optimizers to prevent this problem in the future.");
                output = input;
            }
            return output;
        }

        @Override
        @Nonnull
        public Collection<Resource> optimize(@Nonnull Collection<Resource> inputs) throws Exception {
            Collection<Resource> optimized = OptimizationContextFactory.this._optimizer.optimize(inputs, this);
            for (Resource resource : optimized) {
                resource.touch();
            }
            return optimized;
        }

        @Override
        @Nullable
        public Resource findAndOptimizeFor(@Nonnull String uri) throws Exception {
            Object unoptimized = OptimizationContextFactory.this._resourceProvider.findBy(uri);
            Resource optimized = unoptimized != null ? this.optimize((Resource)unoptimized) : null;
            return optimized;
        }

        @Override
        @Nullable
        public String findOptimizeAndReturnUriFor(@Nonnull String uri) throws Exception {
            Resource optimized = this.findAndOptimizeFor(uri);
            return optimized != null ? OptimizationContextFactory.this._resourceRequestUriGenerator.generate(optimized) : null;
        }
    }
}

