/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing.yui;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.optimizing.yui.YuiClassLoaderFactory;

public abstract class FacadeSupport {
    @Nonnull
    protected static final ClassLoader CLASS_LOADER = YuiClassLoaderFactory.yuiClassLoader();

    @Nonnull
    protected static Class<?> loadYuiClass(@Nonnull String className) {
        try {
            return CLASS_LOADER.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Nonnull
    protected static Constructor<?> getYuiConstructor(@Nonnull Class<?> type, Class<?> ... arguments) {
        try {
            return type.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Nonnull
    protected static Method getYuiMethod(@Nonnull Class<?> type, @Nonnull String name, Class<?> ... arguments) {
        try {
            return type.getMethod(name, arguments);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

