/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.apache.commons.codec.binary.Base64;
import org.echocat.jomon.runtime.codec.HashFunction;
import org.echocat.jomon.runtime.codec.HashFunctionUtils;

public abstract class HashFunctionSupport<T extends HashFunctionSupport<T>>
implements HashFunction {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    @Nonnull
    public abstract T update(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    @Nonnull
    public T update(@Nullable String with) {
        this.update(with, DEFAULT_CHARSET);
        return this.thisObject();
    }

    @Nonnull
    public T update(@Nullable String with, @Nonnull Charset charset) {
        if (with != null) {
            byte[] bytes = with.getBytes(charset);
            this.update(bytes, 0, bytes.length);
        }
        return this.thisObject();
    }

    @Nonnull
    public T update(byte with) {
        this.update(new byte[]{with}, 0, 1);
        return this.thisObject();
    }

    @Nonnull
    public T update(@Nullable byte[] with) {
        if (with != null) {
            this.update(with, 0, with.length);
        }
        return this.thisObject();
    }

    @Nonnull
    public T update(@Nullable @WillNotClose InputStream is) throws IOException {
        if (is != null) {
            byte[] buffer = new byte[4096];
            int read = is.read(buffer);
            while (read > -1) {
                this.update(buffer, 0, read);
                read = is.read(buffer);
            }
        }
        return this.thisObject();
    }

    @Nonnull
    public T update(@Nullable File file) throws IOException {
        if (file != null) {
            try (FileInputStream is = new FileInputStream(file);){
                this.update(is);
            }
        }
        return this.thisObject();
    }

    @Override
    @Nonnull
    public String asHexString() {
        return HashFunctionUtils.asHexString(this.asBytes());
    }

    @Override
    @Nonnull
    public byte[] asBase64() {
        return Base64.encodeBase64((byte[])this.asBytes());
    }

    @Override
    @Nonnull
    public String asBase64String() {
        return new String(this.asBase64(), DEFAULT_CHARSET);
    }

    @Nonnull
    protected T thisObject() {
        return (T)this;
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o == null || this.getClass() != o.getClass()) {
            result = false;
        } else {
            HashFunctionSupport that = (HashFunctionSupport)o;
            result = Arrays.equals(this.asBytes(), that.asBytes());
        }
        return result;
    }

    public int hashCode() {
        return Arrays.hashCode(this.asBytes());
    }
}

