/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.codec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.codec.HashFunctionSupport;

public abstract class JvmMessageDigestBasedHashFunctionSupport<T extends JvmMessageDigestBasedHashFunctionSupport<T>>
extends HashFunctionSupport<T> {
    private final MessageDigest _delegate;

    protected JvmMessageDigestBasedHashFunctionSupport(@Nonnull String algorithm) {
        try {
            this._delegate = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Could not create an instance of " + algorithm + " because it is not supported by JVM.", e);
        }
    }

    protected JvmMessageDigestBasedHashFunctionSupport(@Nonnull String algorithm, @Nonnull String provider) {
        try {
            this._delegate = MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Could not create an instance of " + algorithm + " because it is not supported by JVM.", e);
        }
        catch (NoSuchProviderException e) {
            NoSuchElementException exception = new NoSuchElementException("Could not create an instance of " + algorithm + " because provider " + provider + " could not be found.");
            exception.initCause(e);
            throw exception;
        }
    }

    protected JvmMessageDigestBasedHashFunctionSupport(@Nonnull String algorithm, @Nonnull Provider provider) {
        try {
            this._delegate = MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Could not create an instance of " + algorithm + " because it is not supported by JVM.", e);
        }
    }

    @Override
    @Nonnull
    public T update(@Nullable byte[] with, @Nonnegative int offset, @Nonnegative int length) {
        if (with != null) {
            this._delegate.update(with, offset, length);
        }
        return (T)((JvmMessageDigestBasedHashFunctionSupport)this.thisObject());
    }

    @Override
    @Nonnull
    public byte[] asBytes() {
        return this._delegate.digest();
    }
}

