/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.concurrent;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.concurrent.RetryingStatus;
import org.echocat.jomon.runtime.concurrent.RetryingStrategy;
import org.echocat.jomon.runtime.concurrent.StopWatch;

public class Retryer {
    @Nullable
    public static void executeWithRetry(@Nonnull Runnable what, @Nonnull RetryingStrategy<Void> with) {
        Retryer.executeWithRetry(what, with, RuntimeException.class);
    }

    @Nullable
    public static <E extends Throwable> void executeWithRetry(@Nonnull Runnable what, @Nonnull RetryingStrategy<Void> with, @Nonnull Class<E> throwable) throws E {
        Retryer.executeWithRetry(Retryer.toCallable(what), with, throwable);
    }

    @Nullable
    public static <T> T executeWithRetry(@Nonnull Callable<T> what, @Nonnull RetryingStrategy<T> with) {
        return Retryer.executeWithRetry(what, with, RuntimeException.class);
    }

    @Nullable
    public static <T, E extends Throwable> T executeWithRetry(@Nonnull Callable<T> what, @Nonnull RetryingStrategy<T> with, @Nonnull Class<E> throwable) throws E {
        boolean retry;
        StopWatch stopWatch = new StopWatch();
        long currentTry = 1L;
        T result = null;
        do {
            with.beforeTry(new RetryingStatus(currentTry, stopWatch.getCurrentDuration()));
            try {
                result = what.call();
                retry = with.isRetryRequiredForResult(result, new RetryingStatus(currentTry, stopWatch.getCurrentDuration()));
            }
            catch (Throwable e) {
                if (with.isRetryRequiredForException(e, new RetryingStatus(currentTry, stopWatch.getCurrentDuration()))) {
                    retry = true;
                }
                if (throwable.isInstance(e)) {
                    throw (Throwable)throwable.cast(e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Could not execute " + what + " with " + with + ".", e);
            }
            ++currentTry;
        } while (retry);
        return result;
    }

    @Nonnull
    protected static Callable<Void> toCallable(final @Nonnull Runnable what) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                what.run();
                return null;
            }
        };
    }

    private Retryer() {
    }
}

