/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.io;

import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.runtime.util.ByteCount;

public class ByteUtils {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final int BOOLEAN_CHUNK_SIZE = 1;
    public static final int BYTE_CHUNK_SIZE = 1;
    public static final int SHORT_CHUNK_SIZE = 2;
    public static final int INTEGER_CHUNK_SIZE = 4;
    public static final int LONG_CHUNK_SIZE = 8;
    public static final int FLOAT_CHUNK_SIZE = 4;
    public static final int DOUBLE_CHUNK_SIZE = 8;
    public static final int DEFAULT_STRING_BUFFER_SIZE = 255;
    public static final int DEFAULT_STRING_CHUNK_SIZE = ByteUtils.getStringChunkSizeFor(255);
    public static final ByteCount DEFAULT_BUFFER_SIZE = ByteCount.byteCountOf("1k");

    private ByteUtils() {
    }

    @Nonnegative
    public static int putByte(@Nonnull byte[] b, @Nonnegative int offset, byte val) {
        ByteUtils.checkBufferEnd(b, offset, 1);
        b[offset] = val;
        return 1;
    }

    public static byte getByte(@Nonnull byte[] b, @Nonnegative int offset) {
        ByteUtils.checkBufferEnd(b, offset, 1);
        return b[offset];
    }

    @Nonnegative
    public static int putShort(@Nonnull byte[] b, @Nonnegative int offset, short val) {
        ByteUtils.checkBufferEnd(b, offset, 2);
        b[offset + 1] = (byte)val;
        b[offset] = (byte)(val >>> 8);
        return 2;
    }

    public static short getShort(@Nonnull byte[] b, @Nonnegative int offset) {
        ByteUtils.checkBufferEnd(b, offset, 2);
        return (short)((b[offset + 1] & 0xFF) + (b[offset] << 8));
    }

    @Nonnegative
    public static int putInteger(@Nonnull byte[] b, @Nonnegative int offset, int value) {
        ByteUtils.checkBufferEnd(b, offset, 4);
        b[offset + 3] = (byte)value;
        b[offset + 2] = (byte)(value >>> 8);
        b[offset + 1] = (byte)(value >>> 16);
        b[offset] = (byte)(value >>> 24);
        return 4;
    }

    public static int getInteger(@Nonnull byte[] b, @Nonnegative int offset) {
        ByteUtils.checkBufferEnd(b, offset, 4);
        return (b[offset + 3] & 0xFF) + ((b[offset + 2] & 0xFF) << 8) + ((b[offset + 1] & 0xFF) << 16) + (b[offset] << 24);
    }

    @Nonnegative
    public static int putLong(@Nonnull byte[] b, @Nonnegative int offset, long value) {
        ByteUtils.checkBufferEnd(b, offset, 8);
        b[offset + 7] = (byte)value;
        b[offset + 6] = (byte)(value >>> 8);
        b[offset + 5] = (byte)(value >>> 16);
        b[offset + 4] = (byte)(value >>> 24);
        b[offset + 3] = (byte)(value >>> 32);
        b[offset + 2] = (byte)(value >>> 40);
        b[offset + 1] = (byte)(value >>> 48);
        b[offset] = (byte)(value >>> 56);
        return 8;
    }

    public static long getLong(@Nonnull byte[] b, @Nonnegative int offset) {
        ByteUtils.checkBufferEnd(b, offset, 8);
        return ((long)b[offset + 7] & 0xFFL) + (((long)b[offset + 6] & 0xFFL) << 8) + (((long)b[offset + 5] & 0xFFL) << 16) + (((long)b[offset + 4] & 0xFFL) << 24) + (((long)b[offset + 3] & 0xFFL) << 32) + (((long)b[offset + 2] & 0xFFL) << 40) + (((long)b[offset + 1] & 0xFFL) << 48) + ((long)b[offset] << 56);
    }

    @Nonnegative
    public static int getStringChunkSizeFor(@Nonnegative int bufferSize) {
        return 4 + bufferSize;
    }

    @Nonnegative
    public static byte[] allocateStringChunkFor(@Nonnegative int bufferSize) {
        return new byte[ByteUtils.getStringChunkSizeFor(bufferSize)];
    }

    @Nonnegative
    public static int putString(@Nonnull byte[] b, @Nonnegative int bufferSize, @Nonnegative int offset, @Nullable String value, @Nonnull Charset charset) {
        int chunkSize = ByteUtils.getStringChunkSizeFor(bufferSize);
        ByteUtils.checkBufferEnd(b, offset, chunkSize);
        if (value != null) {
            byte[] bytes = value.getBytes(charset);
            if (bytes.length > bufferSize) {
                throw new IndexOutOfBoundsException("The bytes of the specified string (" + bytes.length + ") exceeded the maximum number of bytes of " + bufferSize + ".");
            }
            ByteUtils.putInteger(b, offset, bytes.length);
            int offsetForBytes = offset + 4;
            System.arraycopy(bytes, 0, b, offsetForBytes, bytes.length);
            int offsetForZeros = offsetForBytes + bytes.length;
            ByteUtils.putZeros(b, offsetForZeros, chunkSize - offsetForZeros);
        } else {
            ByteUtils.putInteger(b, offset, -1);
            ByteUtils.putZeros(b, offset + 4, chunkSize - 4);
        }
        return chunkSize;
    }

    @Nullable
    public static String getString(@Nonnull byte[] b, @Nonnegative int bufferSize, @Nonnegative int offset, @Nonnull Charset charset) {
        int chunkSize = ByteUtils.getStringChunkSizeFor(bufferSize);
        ByteUtils.checkBufferEnd(b, offset, chunkSize);
        int byteCount = ByteUtils.getInteger(b, offset);
        String result = byteCount >= 0 ? new String(b, offset + 4, byteCount, charset) : null;
        return result;
    }

    @Nonnegative
    public static int putZeros(@Nonnull byte[] b, @Nonnegative int offset, @Nonnegative int length) {
        ByteUtils.checkBufferEnd(b, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            b[i] = 0;
        }
        return length;
    }

    public static void checkBufferEnd(@Nonnull byte[] b, @Nonnegative int offset, @Nonnegative int length) {
        ByteUtils.checkOffset(offset);
        int end = offset + length;
        if (b.length < end) {
            throw new IndexOutOfBoundsException("Byte buffer (" + b.length + ") is smaller then expected read end at " + end + ".");
        }
    }

    public static void checkOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Negative offset: " + offset);
        }
    }
}

