/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.io;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.io.UrlStreamHandlerFactory;

public class UrlUtils {
    private static final Iterable<UrlStreamHandlerFactory> URL_STREAM_HANDLER_FACTORIES = UrlUtils.loadUrlStreamHandlerFactories();
    private static volatile boolean c_streamHandlerRegistered;

    public static void registerUrlStreamHandlerIfNeeded() {
        if (!c_streamHandlerRegistered) {
            c_streamHandlerRegistered = true;
            URL.setURLStreamHandlerFactory(new URLStreamHandlerFactoryImpl());
        }
    }

    @Nonnull
    private static Iterable<UrlStreamHandlerFactory> loadUrlStreamHandlerFactories() {
        ArrayList result = new ArrayList();
        CollectionUtils.addAll(result, ServiceLoader.load(UrlStreamHandlerFactory.class));
        return CollectionUtils.asImmutableList(result);
    }

    private UrlUtils() {
    }

    private static class URLStreamHandlerFactoryImpl
    implements URLStreamHandlerFactory {
        private URLStreamHandlerFactoryImpl() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            UrlStreamHandlerFactory factory;
            URLStreamHandler result = null;
            Iterator iterator = URL_STREAM_HANDLER_FACTORIES.iterator();
            while (iterator.hasNext() && (result = (factory = (UrlStreamHandlerFactory)iterator.next()).createURLStreamHandler(protocol)) == null) {
            }
            return result;
        }
    }
}

