/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.logging;

import java.util.ArrayList;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.logging.LoggingEnvironment;
import org.echocat.jomon.runtime.logging.LoggingEnvironmentConfiguration;
import org.echocat.jomon.runtime.logging.LoggingEnvironmentGenerator;

public class LoggingEnvironmentGenerators {
    @Nonnull
    private static final Iterable<LoggingEnvironmentGenerator> ALL = LoggingEnvironmentGenerators.loadAll();
    @Nonnull
    private static final LoggingEnvironmentGenerator DEFAULT = new Combined();

    private LoggingEnvironmentGenerators() {
    }

    @Nonnull
    public static LoggingEnvironmentGenerator getDefault() {
        return DEFAULT;
    }

    @Nonnull
    public static LoggingEnvironmentGenerator loggingEnvironmentGenerator() {
        return LoggingEnvironmentGenerators.getDefault();
    }

    @Nonnull
    public static Iterable<LoggingEnvironmentGenerator> getAll() {
        return ALL;
    }

    @Nonnull
    private static Iterable<LoggingEnvironmentGenerator> loadAll() {
        ArrayList result = new ArrayList();
        CollectionUtils.addAll(result, ServiceLoader.load(LoggingEnvironmentGenerator.class));
        return CollectionUtils.asImmutableList(result);
    }

    private static class Combined
    implements LoggingEnvironmentGenerator {
        private Combined() {
        }

        @Override
        @Nonnull
        public LoggingEnvironment generate(@Nonnull LoggingEnvironmentConfiguration requirement) {
            LoggingEnvironment result = null;
            for (LoggingEnvironmentGenerator generator : ALL) {
                if (!generator.supports(requirement)) continue;
                result = (LoggingEnvironment)generator.generate(requirement);
            }
            if (result == null) {
                throw new IllegalArgumentException("Could not generate environment for " + requirement + ".");
            }
            return result;
        }

        @Override
        public boolean supports(@Nonnull LoggingEnvironmentConfiguration configuration) {
            boolean result = false;
            for (LoggingEnvironmentGenerator generator : ALL) {
                if (!generator.supports(configuration)) continue;
                result = true;
                break;
            }
            return result;
        }
    }
}

