/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.echocat.jomon.runtime.util.SerialGenerator;

public class EncodedSerialGenerator
implements SerialGenerator<String> {
    private static final String ALGORITHM = "AES";
    private final SerialGenerator<Long> _longBasedSerialGenerator;
    private String _password = "gk9s4(03dfj21S/F";
    private int _creationRetries = 10;
    private Cipher _encryptCipher;
    private Cipher _decryptCipher;

    public EncodedSerialGenerator(@Nonnull SerialGenerator<Long> longBasedSerialGenerator) throws Exception {
        this._longBasedSerialGenerator = longBasedSerialGenerator;
        this.init();
    }

    @PostConstruct
    public void init() throws Exception {
        SecretKeySpec key = new SecretKeySpec(this._password.getBytes("UTF-8"), ALGORITHM);
        this._encryptCipher = Cipher.getInstance(ALGORITHM);
        this._encryptCipher.init(1, key);
        this._decryptCipher = Cipher.getInstance(ALGORITHM);
        this._decryptCipher.init(2, key);
    }

    @Nonnull
    public String getPassword() {
        return this._password;
    }

    public void setPassword(@Nonnull String password) {
        this._password = password;
    }

    @Nonnegative
    public int getCreationRetries() {
        return this._creationRetries;
    }

    public void setCreationRetries(@Nonnegative int creationRetries) {
        this._creationRetries = creationRetries;
    }

    @Override
    @Nonnull
    public String next() {
        String encodedSerial;
        int currentTry = 0;
        do {
            try {
                encodedSerial = this.nextInternal();
            }
            catch (RuntimeException e) {
                encodedSerial = null;
                if (currentTry++ < this._creationRetries) continue;
                throw e;
            }
        } while (encodedSerial == null);
        return encodedSerial;
    }

    @Nonnull
    protected String nextInternal() {
        Long serial = this._longBasedSerialGenerator.next();
        String encodedSerial = this.encode(serial);
        long recoveredSerial = this.decode(encodedSerial);
        if (recoveredSerial != serial) {
            throw new IllegalStateException("The encryption/decryption of the serial fails.");
        }
        return encodedSerial;
    }

    @Nonnull
    public String encode(long serial) {
        byte[] serialAsBytes = this.asBytes(serial);
        byte[] encrypted = this.encrypt(serialAsBytes);
        return this.base64Encode(encrypted);
    }

    @Nonnull
    protected String base64Encode(@Nonnull byte[] toEncode) {
        return this.createBase64().encodeToString(toEncode);
    }

    @Nonnull
    protected byte[] encrypt(@Nonnull byte[] toEncrypt) {
        byte[] encoded;
        try {
            encoded = this._encryptCipher.doFinal(toEncrypt);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Could not create serial.", e);
        }
        return encoded;
    }

    @Nonnull
    protected byte[] asBytes(long val) {
        byte[] b = new byte[8];
        b[7] = (byte)val;
        b[6] = (byte)(val >>> 8);
        b[5] = (byte)(val >>> 16);
        b[4] = (byte)(val >>> 24);
        b[3] = (byte)(val >>> 32);
        b[2] = (byte)(val >>> 40);
        b[1] = (byte)(val >>> 48);
        b[0] = (byte)(val >>> 56);
        return b;
    }

    public long decode(@Nonnull String encodedSerial) {
        byte[] encrypted = this.base64decode(encodedSerial);
        byte[] serialAsBytes = this.decrypt(encrypted);
        return this.asLong(serialAsBytes);
    }

    @Nonnull
    protected byte[] base64decode(@Nonnull String toDecode) {
        return this.createBase64().decode(toDecode);
    }

    @Nonnull
    protected byte[] decrypt(@Nonnull byte[] toDecrypt) {
        byte[] encoded;
        try {
            encoded = this._decryptCipher.doFinal(toDecrypt);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Could not create serial.", e);
        }
        return encoded;
    }

    @Nonnull
    protected long asLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + ((long)b[0] << 56);
    }

    @Override
    @Nonnull
    public Class<String> getGeneratedType() {
        return String.class;
    }

    @Nonnull
    protected Base64 createBase64() {
        return new Base64(0, null, true);
    }
}

