/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.echocat.jomon.runtime.annotations.Excluding;
import org.echocat.jomon.runtime.annotations.Including;
import org.echocat.jomon.runtime.generation.IncreasingRequirement;
import org.echocat.jomon.runtime.numbers.DoubleGenerator;
import org.echocat.jomon.runtime.numbers.DoubleRangeRequirement;
import org.echocat.jomon.runtime.numbers.ExactDoubleRequirement;
import org.echocat.jomon.runtime.numbers.NumberRequirement;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.DurationRequirement;

@ThreadSafe
public class IncreasingDurationRequirement
implements DurationRequirement,
IncreasingRequirement<Duration> {
    private final Duration _initialValue;
    private NumberRequirement<Double> _factor = new ExactDoubleRequirement(1.1);
    private Duration _next;

    public IncreasingDurationRequirement(@Nonnull String initialValue) {
        this(new Duration(initialValue));
    }

    public IncreasingDurationRequirement(@Nonnegative long initialValue) {
        this(new Duration(initialValue));
    }

    public IncreasingDurationRequirement(@Nonnull Duration initialValue) {
        this._initialValue = initialValue;
        this._next = initialValue;
    }

    @Nonnull
    public IncreasingDurationRequirement withFactor(@Nonnegative double factor) {
        return this.withFactor(new ExactDoubleRequirement(factor));
    }

    @Nonnull
    public IncreasingDurationRequirement withFactor(@Nonnegative @Including double from, @Nonnegative @Excluding double to) {
        return this.withFactor(new DoubleRangeRequirement(from, to));
    }

    @Nonnull
    public IncreasingDurationRequirement withFactor(@Nonnull NumberRequirement<Double> factor) {
        this._factor = factor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Duration next() {
        IncreasingDurationRequirement increasingDurationRequirement = this;
        synchronized (increasingDurationRequirement) {
            Duration now = this._next;
            this._next = this.generateNext(now, this._factor);
            return now;
        }
    }

    @Nonnull
    protected Duration generateNext(@Nonnull Duration current, @Nonnull NumberRequirement<Double> factorRequirement) {
        Double factor = DoubleGenerator.generateDouble(factorRequirement);
        long millis = current.in(TimeUnit.MILLISECONDS);
        long toAdd = Math.round((double)millis * factor);
        return current.plus(toAdd);
    }

    @Nonnull
    public Duration getInitialValue() {
        return this._initialValue;
    }

    @Nonnull
    public NumberRequirement<Double> getFactor() {
        return this._factor;
    }
}

