/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.runtime.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(value=Adapter.class)
@ThreadSafe
@Immutable
public class PhoneNumber {
    private static final PhoneNumberUtil UTIL = PhoneNumberUtil.getInstance();
    private final Phonenumber.PhoneNumber _value;

    public PhoneNumber(@Nonnull String value) throws IllegalArgumentException {
        this(value, null);
    }

    public PhoneNumber(@Nonnull String value, @Nullable String region) throws IllegalArgumentException {
        try {
            this._value = UTIL.parse(value, region != null ? region.toUpperCase() : null);
        }
        catch (NumberParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected PhoneNumber(@Nonnull PhoneNumber original) {
        this._value = original._value;
        UTIL.getRegionCodeForNumber(this._value);
    }

    public boolean hasCountry() {
        return this._value.hasCountryCode();
    }

    @Nullable
    public Integer getCountry() {
        return this._value.hasCountryCode() ? Integer.valueOf(this._value.getCountryCode()) : null;
    }

    public boolean hasCountryCode() {
        return this.getCountryCode() != null;
    }

    @Nullable
    public String getCountryCode() {
        return this._value.hasCountryCode() ? UTIL.getRegionCodeForNumber(this._value) : null;
    }

    public boolean hasNational() {
        return this._value.hasNationalNumber();
    }

    @Nullable
    public Long getNational() {
        return this._value.hasExtension() ? Long.valueOf(this._value.getNationalNumber()) : null;
    }

    public boolean hasExtension() {
        return this._value.hasExtension();
    }

    @Nullable
    public String getExtension() {
        return this._value.hasExtension() ? this._value.getExtension() : null;
    }

    @Nonnull
    public String format() {
        return this.format(Format.e164);
    }

    @Nonnull
    public String format(@Nonnull Format format) {
        PhoneNumberUtil.PhoneNumberFormat phoneNumberFormat = PhoneNumber.asPhoneNumberFormat(format);
        return UTIL.format(this._value, phoneNumberFormat);
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (!(o instanceof PhoneNumber)) {
            result = false;
        } else {
            PhoneNumber that = (PhoneNumber)o;
            result = this._value != null ? this._value.equals((Object)that._value) : that._value == null;
        }
        return result;
    }

    public int hashCode() {
        return this._value != null ? this._value.hashCode() : 0;
    }

    public String toString() {
        return this.format();
    }

    @Nonnull
    private static PhoneNumberUtil.PhoneNumberFormat asPhoneNumberFormat(@Nonnull Format format) {
        PhoneNumberUtil.PhoneNumberFormat phoneNumberFormat;
        if (format == Format.e164) {
            phoneNumberFormat = PhoneNumberUtil.PhoneNumberFormat.E164;
        } else if (format == Format.international) {
            phoneNumberFormat = PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL;
        } else if (format == Format.national) {
            phoneNumberFormat = PhoneNumberUtil.PhoneNumberFormat.NATIONAL;
        } else if (format == Format.rfc3966) {
            phoneNumberFormat = PhoneNumberUtil.PhoneNumberFormat.RFC3966;
        } else {
            throw new IllegalArgumentException("Don't know to handle " + (Object)((Object)format) + ".");
        }
        return phoneNumberFormat;
    }

    public static class Adapter
    extends XmlAdapter<String, PhoneNumber> {
        public PhoneNumber unmarshal(String v) throws Exception {
            return v != null ? new PhoneNumber(v) : null;
        }

        public String marshal(PhoneNumber v) throws Exception {
            return v != null ? v.format() : null;
        }
    }

    public static enum Format {
        e164,
        international,
        national,
        rfc3966;

    }
}

