/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import com.google.common.io.CountingInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FilenameUtils;
import org.echocat.jomon.resources.NameEnabledResource;
import org.echocat.jomon.resources.PrivateUrlEnabledResource;
import org.echocat.jomon.resources.ResourceSupport;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.UriEnabledResource;
import org.echocat.jomon.runtime.codec.Md5Utils;

@ThreadSafe
public class ClassPathResource
extends ResourceSupport
implements NameEnabledResource,
UriEnabledResource,
PrivateUrlEnabledResource {
    private final String _path;
    private final ResourceType _type;
    private final ClassLoader _classLoader;
    private final Date _lastModified = new Date();
    private final String _classPath;
    private volatile byte[] _md5;
    private volatile Long _size;
    private volatile Boolean _existing;

    protected ClassPathResource(@Nonnull String path, @Nonnull ResourceType type, @Nonnull ClassLoader classLoader) {
        this._path = path;
        this._type = type;
        this._classLoader = classLoader;
        this._classPath = path.substring(1);
    }

    @Override
    @Nonnull
    public InputStream openInputStream() throws IOException {
        InputStream inputStream = this._classLoader.getResourceAsStream(this._classPath);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not find resource: " + this._path);
        }
        return inputStream;
    }

    @Override
    @Nonnull
    public ResourceType getType() {
        return this._type;
    }

    @Override
    @Nonnull
    public byte[] getMd5() throws IOException {
        if (this._md5 == null) {
            this.initMd5AndSize();
        }
        return this._md5;
    }

    @Override
    public long getSize() throws IOException {
        if (this._size == null) {
            this.initMd5AndSize();
        }
        return this._size;
    }

    @Override
    public Date getLastModified() throws IOException {
        return this._lastModified;
    }

    @Override
    public boolean isExisting() throws IOException {
        if (this._existing == null) {
            this._existing = this._classLoader.getResource(this._path.substring(1)) != null;
        }
        return this._existing;
    }

    protected void initMd5AndSize() throws IOException {
        try (InputStream inputStream = this.openInputStream();
             CountingInputStream countingInputStream = new CountingInputStream(inputStream);){
            this._md5 = Md5Utils.md5Of((InputStream)countingInputStream).asBytes();
            this._size = countingInputStream.getCount();
        }
    }

    @Override
    @Nonnull
    public String getName() {
        return FilenameUtils.getName((String)this._path);
    }

    @Override
    @Nonnull
    public String getUri() {
        return this._path;
    }

    @Override
    public boolean isGenerated() throws IOException {
        return false;
    }

    @Override
    @Nonnull
    public URL getPrivateUrl() throws IOException {
        return new URL("classpath:" + this._path);
    }

    @Nonnull
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }
}

