/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import com.Ostermiller.util.MD5OutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.FileResource;
import org.echocat.jomon.resources.NameEnabledFileResource;
import org.echocat.jomon.resources.NameEnabledResource;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceGenerator;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.UriEnabledResource;

@NotThreadSafe
public class FileResourceGenerator
extends ResourceGenerator {
    private static final File TEMPORARY_BASE_DIRECTORY = new File(System.getProperty("java.io.tmpdir", "." + File.separator + "tmp"), FileResourceGenerator.class.getPackage().getName().replace('.', File.separatorChar));
    private final File _temporaryFile = new File(TEMPORARY_BASE_DIRECTORY, UUID.randomUUID().toString());
    private final OutputStream _outputStream;
    private final MD5OutputStream _md5OutputStream;

    public FileResourceGenerator(@Nonnull Resource originalResource) throws IOException {
        this(originalResource, null);
    }

    public FileResourceGenerator(@Nonnull Resource originalResource, @Nullable String name) throws IOException {
        this(originalResource.getType(), originalResource, name);
    }

    public FileResourceGenerator(@Nonnull ResourceType type) throws IOException {
        this(type, null);
    }

    public FileResourceGenerator(@Nonnull ResourceType type, @Nullable String name) throws IOException {
        this(type, null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileResourceGenerator(@Nonnull ResourceType type, @Nullable Resource originalResource, @Nullable String name) throws IOException {
        super(type, originalResource, name);
        this._temporaryFile.getParentFile().mkdirs();
        boolean success = false;
        this._outputStream = new FileOutputStream(this._temporaryFile);
        try {
            this._md5OutputStream = new MD5OutputStream(this._outputStream);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((OutputStream)this._outputStream);
            }
        }
    }

    @Override
    protected FileResource generateResource() throws IOException {
        byte[] md5 = this._md5OutputStream.getHash();
        File targetFile = this.createTargetFileFor(md5, this._temporaryFile.length(), this.getType());
        if (!targetFile.isFile() || targetFile.length() != this._temporaryFile.length()) {
            FileUtils.deleteQuietly((File)targetFile);
            FileUtils.moveFile((File)this._temporaryFile, (File)targetFile);
        } else {
            FileUtils.deleteQuietly((File)this._temporaryFile);
        }
        FileResource result = this.getName() != null ? new NameEnabledFileResource(targetFile, md5, this.getType(), this.getName(), true) : (this.getOriginalResource() instanceof NameEnabledResource ? new NameEnabledFileResource(targetFile, md5, this.getType(), ((NameEnabledResource)this.getOriginalResource()).getName(), true) : (this.getOriginalResource() instanceof UriEnabledResource ? new NameEnabledFileResource(targetFile, md5, this.getType(), ((UriEnabledResource)this.getOriginalResource()).getUri(), true) : new FileResource(targetFile, md5, this.getType(), true)));
        return result;
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this._md5OutputStream;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.closeQuietly((OutputStream)this._md5OutputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)this._outputStream);
        }
    }

    @Override
    public void drop() throws IOException {
        try {
            super.drop();
        }
        finally {
            this._temporaryFile.delete();
        }
    }

    @Nonnull
    protected File createTargetFileFor(@Nonnull byte[] md5, @Nonnegative long size, @Nonnull ResourceType type) {
        String md5AsHex = Hex.encodeHexString((byte[])md5);
        return new File(TEMPORARY_BASE_DIRECTORY, md5AsHex + "_" + size + "." + type);
    }
}

