/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.ResourceSupport;
import org.echocat.jomon.resources.ResourceType;

public class MemoryResource
extends ResourceSupport {
    private final byte[] _content;
    private final byte[] _md5;
    private final ResourceType _type;
    private final boolean _generated;
    private final Date _lastModified = new Date();

    public MemoryResource(@Nonnull byte[] content, @Nonnull byte[] md5, @Nonnull ResourceType type, boolean generated) {
        this._content = content;
        this._md5 = md5;
        this._type = type;
        this._generated = generated;
    }

    @Override
    @Nonnull
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this._content);
    }

    @Override
    @Nonnull
    public ResourceType getType() {
        return this._type;
    }

    @Override
    @Nonnull
    public byte[] getMd5() {
        return this._md5;
    }

    @Override
    public long getSize() {
        return this._content.length;
    }

    @Override
    public Date getLastModified() {
        return this._lastModified;
    }

    @Override
    public boolean isExisting() throws IOException {
        return true;
    }

    @Override
    public boolean isGenerated() throws IOException {
        return this._generated;
    }
}

