/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.annotation.Nonnull;

public class ResourceType {
    public static final ResourceType bin = new ResourceType("bin", "application/octet-stream");
    public static final ResourceType png = new ResourceType("png", "image/png");
    public static final ResourceType jpeg = new ResourceType("jpeg", "image/jpeg");
    public static final ResourceType gif = new ResourceType("gif", "image/gif");
    public static final ResourceType js = new ResourceType("js", "text/javascript");
    public static final ResourceType svg = new ResourceType("svg", "image/svg+xml");
    public static final ResourceType css = new ResourceType("css", "text/css");
    public static final ResourceType html = new ResourceType("html", "text/html");
    public static final ResourceType xml = new ResourceType("xml", "application/xml");
    public static final ResourceType txt = new ResourceType("txt", "text/plain");
    private static final Set<ResourceType> SYSTEM_TYPES;
    private final String _name;
    private final MimeType _mimeType;

    private static void enrichWithValuesFromProperties(@Nonnull Set<ResourceType> types) throws Exception {
        Enumeration<URL> urls = ResourceType.class.getClassLoader().getResources("META-INF/mimeTypes.properties");
        while (urls.hasMoreElements()) {
            URL resourceUrl = urls.nextElement();
            Properties properties = new Properties();
            try (InputStream is = resourceUrl.openStream();){
                properties.load(is);
            }
            for (Map.Entry<Object, Object> keyAndValue : properties.entrySet()) {
                types.add(new ResourceType(keyAndValue.getKey().toString(), keyAndValue.getValue().toString()));
            }
        }
    }

    private static void enrichWithValuesFromStaticFields(@Nonnull Set<ResourceType> types) throws Exception {
        for (Field field : ResourceType.class.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) || !ResourceType.class.equals(field.getType())) continue;
            types.add((ResourceType)field.get(null));
        }
    }

    @Nonnull
    public static Set<ResourceType> getSystemTypes() {
        return SYSTEM_TYPES;
    }

    @Nonnull
    private static MimeType parseMimeType(@Nonnull String rawMimeType) throws IllegalArgumentException {
        try {
            return new MimeType(rawMimeType);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException("Could not parse: " + rawMimeType, e);
        }
    }

    public ResourceType(@Nonnull String name, @Nonnull String rawMimeType) throws IllegalArgumentException {
        this(name, ResourceType.parseMimeType(rawMimeType));
    }

    public ResourceType(@Nonnull String name, @Nonnull MimeType mimeType) throws IllegalArgumentException {
        if (!mimeType.getParameters().isEmpty()) {
            throw new IllegalArgumentException("The provided mimeType '" + mimeType + "' has parameters.");
        }
        this._name = name;
        this._mimeType = mimeType;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public MimeType toMimeType() {
        return this.createCopyOf(this._mimeType);
    }

    @Nonnull
    public String getContentType() {
        return this._mimeType.toString();
    }

    protected MimeType createCopyOf(@Nonnull MimeType mimeType) {
        return ResourceType.parseMimeType(mimeType.toString());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        boolean result = this == o ? true : (o == null || !(o instanceof ResourceType) ? false : this._name.equals(((ResourceType)o)._name));
        return result;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    static {
        try {
            HashSet<ResourceType> types = new HashSet<ResourceType>();
            ResourceType.enrichWithValuesFromProperties(types);
            ResourceType.enrichWithValuesFromStaticFields(types);
            SYSTEM_TYPES = Collections.unmodifiableSet(types);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve default types.", e);
        }
    }
}

