/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.MemoryResourceGenerator;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.optimizing.CssResourceOptimizer;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.yui.CssCompressorFacade;

public class YuiCssResourceOptimizer
implements CssResourceOptimizer {
    @Override
    @Nonnull
    public Resource optimize(@Nonnull Resource input, @Nonnull OptimizationContext context) throws Exception {
        Resource output;
        if (context.isFeatureEnabled(SKIP_CSS_OPTIMIZATION)) {
            output = input;
        } else {
            try (InputStream inputStream = input.openInputStream();
                 InputStreamReader reader = new InputStreamReader(inputStream);
                 MemoryResourceGenerator generator = new MemoryResourceGenerator(input);){
                try (OutputStreamWriter writer = new OutputStreamWriter(generator);){
                    CssCompressorFacade compressor = new CssCompressorFacade(reader);
                    compressor.compress(writer, -1);
                }
                output = generator.getTemporaryBufferedResource();
            }
        }
        return output;
    }

    @Override
    public boolean isSupporting(@Nonnull ResourceType type) {
        return ResourceType.css.equals(type);
    }

    @Override
    @Nonnull
    public Set<ResourceType> getSupportedResourceTypes() {
        return Collections.singleton(ResourceType.css);
    }
}

