/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.MemoryResourceGenerator;
import org.echocat.jomon.resources.Resource;
import org.echocat.jomon.resources.ResourceType;
import org.echocat.jomon.resources.optimizing.JavaScriptResourceOptimizer;
import org.echocat.jomon.resources.optimizing.OptimizationContext;
import org.echocat.jomon.resources.optimizing.yui.JavaScriptCompressorFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuiJavaScriptResourceOptimizer
implements JavaScriptResourceOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(YuiJavaScriptResourceOptimizer.class);
    private static volatile boolean c_verifyErrorLogged;
    private int _lineBreak = 8000;
    private boolean _munge;
    private boolean _verbose;
    private boolean _preserveAllSemiColons;
    private boolean _enableOptimizations = true;

    public int getLineBreak() {
        return this._lineBreak;
    }

    public void setLineBreak(int lineBreak) {
        this._lineBreak = lineBreak;
    }

    public boolean isMunge() {
        return this._munge;
    }

    public void setMunge(boolean munge) {
        this._munge = munge;
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public boolean isPreserveAllSemiColons() {
        return this._preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this._preserveAllSemiColons = preserveAllSemiColons;
    }

    public boolean isEnableOptimizations() {
        return this._enableOptimizations;
    }

    public void setEnableOptimizations(boolean enableOptimizations) {
        this._enableOptimizations = enableOptimizations;
    }

    @Override
    @Nonnull
    public Resource optimize(@Nonnull Resource input, @Nonnull OptimizationContext context) throws Exception {
        Resource output;
        if (context.isFeatureEnabled(SKIP_JAVA_SCRIPT_OPTIMIZATION)) {
            output = input;
        } else {
            try (InputStream inputStream = input.openInputStream();
                 InputStreamReader reader = new InputStreamReader(inputStream);
                 MemoryResourceGenerator generator = new MemoryResourceGenerator(input);){
                try (OutputStreamWriter writer = new OutputStreamWriter(generator);){
                    try {
                        JavaScriptCompressorFacade compressor = new JavaScriptCompressorFacade(reader);
                        compressor.compress(writer, this._lineBreak, this._munge, this._verbose, this._preserveAllSemiColons, !this._enableOptimizations);
                    }
                    catch (VerifyError e) {
                        if (!c_verifyErrorLogged) {
                            LOG.warn("Could not optimize the sources because got an verifyError while calling the compressor. This message will not appear anymore while running this JVM. The JVM will now not optimize the resources.", (Throwable)e);
                            c_verifyErrorLogged = true;
                        }
                        IOUtils.copy((Reader)reader, (Writer)writer);
                    }
                }
                output = generator.getTemporaryBufferedResource();
            }
        }
        return output;
    }

    @Override
    public boolean isSupporting(@Nonnull ResourceType type) {
        return ResourceType.js.equals(type);
    }

    @Override
    @Nonnull
    public Set<ResourceType> getSupportedResourceTypes() {
        return Collections.singleton(ResourceType.js);
    }
}

