/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing.yui;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.echocat.jomon.resources.optimizing.yui.FacadeSupport;

public class JavaScriptCompressorFacade
extends FacadeSupport {
    protected static final Class<?> COMPRESSOR_CLASS = JavaScriptCompressorFacade.loadYuiClass("com.yahoo.platform.yui.compressor.JavaScriptCompressor");
    protected static final Class<?> ERROR_REPORTER_CLASS = JavaScriptCompressorFacade.loadYuiClass("org.mozilla.javascript.ErrorReporter");
    protected static final Class<?> ERROR_REPORTER_IMPL_CLASS = JavaScriptCompressorFacade.loadYuiClass("org.echocat.jomon.resources.optimizing.yui.ErrorReporterImpl");
    protected static final Constructor<?> COMPRESSOR_CONSTRUCTOR = JavaScriptCompressorFacade.getYuiConstructor(COMPRESSOR_CLASS, Reader.class, ERROR_REPORTER_CLASS);
    protected static final Constructor<?> ERROR_REPORTER_IMPL_CONSTRUCTOR = JavaScriptCompressorFacade.getYuiConstructor(ERROR_REPORTER_IMPL_CLASS, new Class[0]);
    protected static final Method COMPRESS_METHOD = JavaScriptCompressorFacade.getYuiMethod(COMPRESSOR_CLASS, "compress", Writer.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
    private final Object _instance;

    public JavaScriptCompressorFacade(@Nonnull Reader in) throws Exception {
        Object errorReporter = ERROR_REPORTER_IMPL_CONSTRUCTOR.newInstance(new Object[0]);
        this._instance = COMPRESSOR_CONSTRUCTOR.newInstance(in, errorReporter);
    }

    public void compress(@Nonnull Writer out, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) throws Exception {
        try {
            COMPRESS_METHOD.invoke(this._instance, out, linebreak, munge, verbose, preserveAllSemiColons, disableOptimizations);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
    }
}

