/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.resources.optimizing.yui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.echocat.jomon.resources.optimizing.yui.ErrorReporterImpl;

public class YuiClassLoaderFactory {
    private static final ClassLoader CLASS_LOADER = YuiClassLoaderFactory.createClassLoader();

    @Nonnull
    public static ClassLoader yuiClassLoader() {
        return CLASS_LOADER;
    }

    @Nonnull
    private static ClassLoader createClassLoader() {
        return new OverwritingClassLoader(YuiClassLoaderFactory.class.getClassLoader(), YuiClassLoaderFactory.createUrlCopyOf("yuicompressor-2.4.7.jar"), YuiClassLoaderFactory.createUrlCopyOf("rhino-1.7R3.jar")).including(ErrorReporterImpl.class);
    }

    @Nonnull
    private static URL createUrlCopyOf(@Nonnull String fileName) {
        try {
            File file = YuiClassLoaderFactory.getFileFor(fileName);
            try (InputStream is = YuiClassLoaderFactory.class.getResourceAsStream(fileName);){
                if (is == null) {
                    throw new IllegalArgumentException("Could not find resource named: " + fileName);
                }
                try (FileOutputStream os = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            return file.toURI().toURL();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create url copy of " + fileName + ".", e);
        }
    }

    @Nonnull
    private static File getFileFor(@Nonnull String fileName) {
        File directory = YuiClassLoaderFactory.getDirectory();
        directory.mkdirs();
        return new File(directory, fileName);
    }

    @Nonnull
    private static File getDirectory() {
        return new File(System.getProperty("java.io.tmdir", "tmp"), "yuicache");
    }

    private YuiClassLoaderFactory() {
    }

    protected static class OverwritingClassLoader
    extends URLClassLoader {
        @Nonnull
        private final Map<String, Class<?>> _nameToClass = new HashMap();
        @Nonnull
        private final ClassLoader _parent;

        public OverwritingClassLoader(@Nonnull ClassLoader parent, URL ... urls) {
            super(urls, (ClassLoader)null);
            this._parent = parent;
        }

        @Nonnull
        public OverwritingClassLoader including(@Nonnull Class<?> clazz) {
            this._nameToClass.put(clazz.getName(), clazz);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> result = this.findLoadedClass(name);
                if (result == null) {
                    try {
                        result = this.findClass(name);
                    }
                    catch (ClassNotFoundException ignored) {
                        result = this._parent.loadClass(name);
                    }
                }
                if (resolve) {
                    this.resolveClass(result);
                }
                return result;
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> result;
            try {
                result = super.findClass(name);
            }
            catch (ClassNotFoundException ignored) {
                result = this.findClassInternal(name);
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Class<?> findClassInternal(String name) throws ClassNotFoundException {
            Class<?> clazz = this._nameToClass.get(name);
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
            try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");){
                if (is == null) {
                    throw new ClassNotFoundException("Could not find original bytecode of " + clazz.getName() + " in classpath.");
                }
                byte[] classAsBytes = IOUtils.toByteArray((InputStream)is);
                Class<?> clazz2 = this.defineClass(name, classAsBytes, 0, classAsBytes.length);
                return clazz2;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load content of class " + clazz.getName() + ".", e);
            }
        }
    }
}

