/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.testing.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.echocat.jomon.net.FreeTcpPortDetector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestHttpServer
implements Closeable,
TestRule {
    private final Server _server;
    private final InetSocketAddress _address;

    public TestHttpServer() {
        try {
            this._address = TestHttpServer.getFreeLocalHostSocketAddress();
            this._server = TestHttpServer.createServer(this._address);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server.", e);
        }
    }

    public TestHttpServer(@Nonnull Handler handler) {
        this();
        try {
            this.setHandler(handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server for " + handler + ".", e);
        }
    }

    public TestHttpServer(@Nonnull SimpleHandler handler) {
        this();
        try {
            this.setHandler(handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server for " + handler + ".", e);
        }
    }

    public TestHttpServer(@Nonnull String contextPath, @Nonnull Servlet servlet) {
        this();
        try {
            this.setHandler(contextPath, servlet);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create server for " + servlet + " at '" + contextPath + "'.", e);
        }
    }

    @Nonnull
    public Server getServer() {
        return this._server;
    }

    @Nonnull
    public InetSocketAddress getAddress() {
        return this._address;
    }

    public void setHandler(@Nonnull Handler handler) throws Exception {
        if (this._server.isRunning()) {
            this._server.stop();
        }
        this._server.setHandler(handler);
        this._server.start();
    }

    public void setHandler(final @Nonnull SimpleHandler handler) throws Exception {
        this.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    String result = handler.handle(target, request, response);
                    if (result != null) {
                        if (response.getContentType() == null) {
                            response.setContentType("text/plain; charset=UTF-8");
                        }
                        PrintWriter writer = response.getWriter();
                        writer.write(result);
                        writer.flush();
                    }
                }
                catch (IOException | ServletException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                baseRequest.setHandled(true);
            }
        });
    }

    public void setHandler(@Nonnull String contextPath, @Nonnull Servlet servlet) throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(new ServletHolder(servlet), contextPath);
        this.setHandler((Handler)context);
    }

    @Override
    public void close() {
        try {
            this._server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not close " + this._server + ".", e);
        }
    }

    @Nonnull
    public URI getBaseUri() {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this._address.getHostName());
        if (this._address.getPort() != 80) {
            sb.append(':').append(this._address.getPort());
        }
        return URI.create(sb.toString());
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        TestHttpServer.this.close();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    @Nonnull
    private static Server createServer(@Nonnull InetSocketAddress socketAddress) throws Exception {
        Server server = new Server();
        server.addConnector((Connector)TestHttpServer.createConnector(socketAddress, server));
        return server;
    }

    @Nonnull
    private static ServerConnector createConnector(@Nonnull InetSocketAddress socketAddress, Server server) throws IOException {
        ServerConnector connector = new ServerConnector(server);
        connector.setHost(socketAddress.getHostName());
        connector.setPort(socketAddress.getPort());
        return connector;
    }

    @Nonnull
    private static InetSocketAddress getFreeLocalHostSocketAddress() throws IOException {
        InetAddress localHostAddress = TestHttpServer.getLocalHostAddress();
        int port = TestHttpServer.getFreePort(localHostAddress);
        return InetSocketAddress.createUnresolved(localHostAddress.getHostName(), port);
    }

    @Nonnull
    private static InetAddress getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getByName("localhost");
    }

    private static int getFreePort(@Nonnull InetAddress localHostAddress) throws IOException {
        FreeTcpPortDetector detector = new FreeTcpPortDetector(localHostAddress, 10000, 45000);
        return detector.detect();
    }

    public static interface SimpleHandler {
        public String handle(@Nonnull String var1, @Nonnull HttpServletRequest var2, @Nonnull HttpServletResponse var3) throws Exception;
    }
}

