/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http;

import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class HttpResponseException
extends IOException {
    private final int _statusCode;
    private final String _statusMessage;
    private final String _body;

    public HttpResponseException(@Nonnegative int statusCode, @Nullable String statusMessage, @Nullable String body) {
        super(HttpResponseException.buildMessageFrom(statusCode, statusMessage, body));
        this._statusCode = statusCode;
        this._statusMessage = statusMessage;
        this._body = body;
    }

    @Nonnull
    private static String buildMessageFrom(@Nonnegative int statusCode, @Nullable String statusMessage, @Nullable String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(statusCode);
        if (!StringUtils.isEmpty((CharSequence)statusMessage)) {
            sb.append(": ").append(statusMessage);
        }
        if (!StringUtils.isEmpty((CharSequence)body)) {
            sb.append("\n===============================================================================================\n").append(body);
        }
        return sb.toString();
    }

    @Nonnegative
    public int getStatusCode() {
        return this._statusCode;
    }

    @Nullable
    public String getStatusMessage() {
        return this._statusMessage;
    }

    @Nullable
    public String getBody() {
        return this._body;
    }
}

