/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.browsers;

import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.util.Glob;

@ThreadSafe
public class BrowserDefinition {
    private static final Set<String> KNOWN_TABLET_DEVICES = Sets.newHashSet((Object[])new String[]{"ipad", "playbook", "sch-i800", "gt-p1000", "xoom"});
    private final String _userAgent;
    private final Map<String, String> _properties;
    private final String _parent;
    private final Glob _glob;

    public BrowserDefinition(@Nonnull String userAgent, @Nonnull Map<String, String> properties, @Nullable String parent) {
        this._userAgent = userAgent;
        this._properties = properties;
        this._parent = parent;
        try {
            this._glob = new Glob(userAgent, true);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse the userAgent as glob pattern: " + userAgent, e);
        }
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public String getBrowserName() {
        return this.getPropertyValue("Browser");
    }

    public String getDeviceName() {
        return this.getPropertyValue("Device_Name");
    }

    public String getPlatformVersion() {
        return this.getPropertyValue("Platform_Version");
    }

    public String getVersion() {
        String version = this.getPropertyValue("Version");
        String result = "0".equals(version) ? this.getMajorVersion() + "." + this.getMinorVersion() : version;
        return result;
    }

    public String getMajorVersion() {
        return this.getPropertyValue("MajorVer");
    }

    public String getMinorVersion() {
        return this.getPropertyValue("MinorVer");
    }

    public String getPlatform() {
        return this.getPropertyValue("Platform");
    }

    public String getCssVersion() {
        return this.getPropertyValue("CSSVersion");
    }

    public boolean isFrameEnabled() {
        return this.isPropertyTrue("Frames");
    }

    public boolean isIFrameEnabled() {
        return this.isPropertyTrue("IFrames");
    }

    public boolean isCookieEnabled() {
        return this.isPropertyTrue("Cookies");
    }

    public boolean isVbScriptEnabled() {
        return this.isPropertyTrue("VBScript");
    }

    public boolean isJavaScriptEnabled() {
        return this.isPropertyTrue("JavaScript");
    }

    public boolean isJavaAppletsEnabled() {
        return this.isPropertyTrue("JavaApplets");
    }

    public boolean isActiveXControlsEnabled() {
        return this.isPropertyTrue("ActiveXControls");
    }

    public boolean isCdfEnabled() {
        return this.isPropertyTrue("CDF");
    }

    public boolean isAol() {
        return this.isPropertyTrue("AOL");
    }

    public boolean isCrawler() {
        return this.isPropertyTrue("Crawler");
    }

    public boolean isStripper() {
        return this.isPropertyTrue("Stripper");
    }

    public boolean isWapDevice() {
        return this.isPropertyTrue("WAP");
    }

    public boolean isMobileDevice() {
        String browserName;
        boolean result = this.isPropertyTrue("isMobileDevice") ? true : (browserName = this.getBrowserName()) != null && browserName.toLowerCase().contains("mobile") && this.isCrawler();
        return result;
    }

    public boolean isTablet() {
        String deviceName;
        boolean result = this.isMobileDevice() ? (deviceName = this.getDeviceName()) != null && KNOWN_TABLET_DEVICES.contains(deviceName.toLowerCase()) : false;
        return result;
    }

    public boolean isParent() {
        return this._userAgent.equals(this._parent);
    }

    public String getParent() {
        return this._parent;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    Glob getGlob() {
        return this._glob;
    }

    private String getPropertyValue(String name) {
        return this._properties.get(name);
    }

    private boolean isPropertyTrue(String name) {
        String p = this.getPropertyValue(name);
        return p != null && p.equals("true");
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBrowserName());
        if (StringUtils.isNotEmpty((CharSequence)this.getPlatformVersion()) && !"0".equals(this.getPlatformVersion())) {
            sb.append(' ').append(this.getPlatformVersion());
        } else {
            if (StringUtils.isNotEmpty((CharSequence)this.getMajorVersion())) {
                sb.append(' ').append(this.getMajorVersion());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.getMinorVersion())) {
                if (StringUtils.isEmpty((CharSequence)this.getMajorVersion())) {
                    sb.append(' ');
                }
                sb.append('.').append(this.getMinorVersion());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getPlatform())) {
            sb.append(" on ").append(this.getPlatform());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toExternalForm();
    }
}

