/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.browsers;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.cache.Cache;
import org.echocat.jomon.cache.ClearableCache;
import org.echocat.jomon.cache.LimitedCache;
import org.echocat.jomon.cache.LruCache;
import org.echocat.jomon.cache.management.CacheDefinition;
import org.echocat.jomon.cache.management.CacheProvider;
import org.echocat.jomon.cache.management.DefaultCacheDefinition;
import org.echocat.jomon.net.http.browsers.BrowserDefinition;
import org.echocat.jomon.net.http.browsers.BrowserDefinitionParser;
import org.echocat.jomon.runtime.util.Duration;
import org.echocat.jomon.runtime.util.Entry;

public class BrowserDefinitionFactory {
    private URL _browserDefinitionFile = BrowserDefinitionParser.DEFAULT_BROWSER_DEFINITION_FILE;
    private final Cache<String, BrowserDefinition> _cache;
    private List<BrowserDefinition> _browserDefinitions;

    public BrowserDefinitionFactory(@Nonnull CacheProvider cacheProvider) {
        this._cache = cacheProvider.provide(this.getClass(), "definitions", (CacheDefinition)((DefaultCacheDefinition)DefaultCacheDefinition.lruCache(String.class, BrowserDefinition.class).withCapacity(10000L)).withMaximumLifetime("1d"));
    }

    public BrowserDefinitionFactory() {
        this._cache = new LruCache(String.class, BrowserDefinition.class);
        ((LimitedCache)this._cache).setMaximumLifetime(new Duration("1d"));
        ((LimitedCache)this._cache).setCapacity(Long.valueOf(10000L));
    }

    public void setBrowserDefinitionFile(@Nonnull URL browserDefinitionFile) {
        this._browserDefinitionFile = browserDefinitionFile;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this._cache instanceof ClearableCache) {
            ((ClearableCache)this._cache).clear();
        }
        try (BrowserDefinitionParser.Rows rows = new BrowserDefinitionParser(this._browserDefinitionFile).iterator();){
            this._browserDefinitions = this.parseRows(rows);
        }
    }

    @Nonnull
    public BrowserDefinition getByUserAgent(@Nonnull String userAgent) {
        BrowserDefinition browserDefinition = (BrowserDefinition)this._cache.get((Object)userAgent);
        if (browserDefinition == null) {
            browserDefinition = this.findFirstMatchInBrowserDefinitions(userAgent);
            this._cache.put((Object)userAgent, (Object)browserDefinition);
        }
        return browserDefinition;
    }

    @Nonnull
    private List<BrowserDefinition> parseRows(@Nonnull BrowserDefinitionParser.Rows rows) throws Exception {
        ArrayList<BrowserDefinition> browserDefinitions = new ArrayList<BrowserDefinition>();
        HashMap<String, Map<String, String>> parentUserAgentToProperties = new HashMap<String, Map<String, String>>();
        while (rows.hasNext()) {
            BrowserDefinitionParser.Row row = rows.next();
            BrowserDefinition browserDefinition = this.createBrowserDefinitionFrom(row, parentUserAgentToProperties);
            if (browserDefinition.isParent()) {
                parentUserAgentToProperties.put(browserDefinition.getUserAgent(), browserDefinition.getProperties());
            }
            browserDefinitions.add(browserDefinition);
        }
        return browserDefinitions;
    }

    @Nonnull
    private BrowserDefinition createBrowserDefinitionFrom(@Nonnull BrowserDefinitionParser.Row row, @Nonnull Map<String, Map<String, String>> parentUserAgentToProperties) throws Exception {
        String plainUserAgent = row.getValue("PropertyName");
        if (plainUserAgent == null) {
            throw new IllegalAccessException("The provided " + row + " contains a null UserAgent.");
        }
        String userAgent = this.normalizeUserAgent(plainUserAgent);
        String parentUserAgent = row.getValue("Parent");
        if (parentUserAgent == null) {
            throw new IllegalAccessException("The provided " + row + " contains a null Parent.");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        this.enrichWithPropertiesOfParentIfPossible(properties, userAgent, parentUserAgent, parentUserAgentToProperties);
        this.enrichWithPropertiesFromRow(properties, row);
        return new BrowserDefinition(userAgent, properties, parentUserAgent);
    }

    private void enrichWithPropertiesFromRow(@Nonnull Map<String, String> properties, @Nonnull BrowserDefinitionParser.Row row) {
        for (Entry<String, String> entry : row) {
            String value = (String)entry.getValue();
            if ("default".equals(value) || StringUtils.isEmpty((CharSequence)value)) continue;
            properties.put((String)entry.getKey(), value);
        }
    }

    private void enrichWithPropertiesOfParentIfPossible(@Nonnull Map<String, String> properties, @Nonnull String actualUserAgent, @Nullable String parentUserAgent, @Nonnull Map<String, Map<String, String>> parentUserAgentToProperties) {
        Map<String, String> parentUserAgentProperties;
        if (parentUserAgent != null && !parentUserAgent.equals(actualUserAgent) && (parentUserAgentProperties = parentUserAgentToProperties.get(parentUserAgent)) != null) {
            properties.putAll(parentUserAgentProperties);
        }
    }

    @Nonnull
    private String normalizeUserAgent(@Nonnull String plainUserAgent) {
        String userAgent = plainUserAgent.startsWith("[") && plainUserAgent.endsWith("]") ? plainUserAgent.substring(1, plainUserAgent.length() - 1) : plainUserAgent;
        return userAgent;
    }

    @Nonnull
    private BrowserDefinition findFirstMatchInBrowserDefinitions(@Nonnull String userAgent) {
        BrowserDefinition result = null;
        Iterator<BrowserDefinition> i = this._browserDefinitions.iterator();
        while (i.hasNext() && (result == null || this.isNotMobileOrTabletDevice(result) && result.getMajorVersion() == null)) {
            BrowserDefinition browserDefinition = i.next();
            if (!browserDefinition.getGlob().matches(userAgent) || result != null && "Default Browser".equals(browserDefinition.getBrowserName())) continue;
            result = browserDefinition;
        }
        if (result == null) {
            throw new IllegalStateException("Could not find any browserDefinition for userAgent '" + userAgent + "'?");
        }
        return result;
    }

    private boolean isNotMobileOrTabletDevice(BrowserDefinition result) {
        return !result.isMobileDevice() && !result.isTablet();
    }
}

