/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.browsers;

import au.com.bytecode.opencsv.CSVReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.echocat.jomon.net.http.HttpUtils;
import org.echocat.jomon.net.http.browsers.BrowserDefinitionFactory;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.iterators.ConvertingIterator;
import org.echocat.jomon.runtime.util.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BrowserDefinitionParser
implements Iterable<Row> {
    static final URL DEFAULT_BROWSER_DEFINITION_FILE = BrowserDefinitionFactory.class.getResource("defaultBrowserDefinitions.csv");
    static final String BROWSER_DEFINITION_DATE_PATTERN = "EEE, d MMM yyyy hh:mm:ss Z";
    private static final Logger LOG = LoggerFactory.getLogger(BrowserDefinitionParser.class);
    private static final String EXPECTED_FIRST_COLUMNS_CONTENT = "GJK_Browscap_Version";
    private static final String DEFAULT_PROPERTIES_CONTENT = "DefaultProperties";
    private final URL _browserDefinitionFile;

    BrowserDefinitionParser(@Nonnull URL browserDefinitionFile) {
        this._browserDefinitionFile = browserDefinitionFile;
    }

    public Rows iterator() {
        Rows result;
        try {
            result = this.getFromUrl(this._browserDefinitionFile);
        }
        catch (Exception e) {
            LOG.warn("Could not open the browserDefinition file '" + this._browserDefinitionFile + "' which was bufferred from original remote location. Fallback to default version.", (Throwable)e);
            try {
                result = this.getFromUrl(DEFAULT_BROWSER_DEFINITION_FILE);
            }
            catch (Exception secondException) {
                throw new RuntimeException("Could not load default browserDefinition file from: " + DEFAULT_BROWSER_DEFINITION_FILE, secondException);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Rows getFromUrl(@Nonnull URL browserDefinitionFile) throws Exception {
        Rows result;
        Reader reader;
        boolean success = false;
        if ("file".equals(browserDefinitionFile.getProtocol())) {
            File file = new File(browserDefinitionFile.toURI());
            reader = new FileReader(file);
        } else {
            reader = "jar".equals(browserDefinitionFile.getProtocol()) ? new InputStreamReader(browserDefinitionFile.openStream()) : HttpUtils.makeGetRequestAndReturnBodyReaderFor(browserDefinitionFile);
        }
        try {
            result = this.get(reader);
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Rows get(@Nonnull Reader reader) throws Exception {
        boolean success = false;
        CSVReader cr = new CSVReader(reader, ',', '\"');
        try {
            Rows result = new Rows(cr);
            success = true;
            Rows rows = result;
            return rows;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((Closeable)cr);
            }
        }
    }

    class Row
    implements Iterable<Entry<String, String>> {
        private final List<String> _row;
        private final Map<String, Integer> _columnNamesToIndex;

        private Row(@Nonnull List<String> row, Map<String, Integer> columnNamesToIndex) {
            this._row = row;
            this._columnNamesToIndex = columnNamesToIndex;
        }

        @Override
        public Iterator<Entry<String, String>> iterator() {
            return new ConvertingIterator<Map.Entry<String, Integer>, Entry<String, String>>(this._columnNamesToIndex.entrySet().iterator()){

                protected Entry<String, String> convert(Map.Entry<String, Integer> input) {
                    String value = (String)Row.this._row.get(input.getValue());
                    return new Entry.Impl((Object)input.getKey(), (Object)value);
                }
            };
        }

        @Nullable
        String getValue(@Nonnull String key) {
            Integer index = this._columnNamesToIndex.get(key);
            return index != null ? this._row.get(index) : null;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    class Rows
    implements CloseableIterator<Row> {
        private final CSVReader _csvReader;
        private final long _version;
        private final Date _date;
        private final Map<String, Integer> _columnNamesToIndex;
        private Boolean _hasNext;
        private String[] _next;

        private Rows(CSVReader csvReader) throws Exception {
            this._csvReader = csvReader;
            this.sanityCheckOfHeaderLines(csvReader);
            this._version = Long.valueOf(this._next[0]);
            this._date = new SimpleDateFormat(BrowserDefinitionParser.BROWSER_DEFINITION_DATE_PATTERN, Locale.US).parse(this._next[1]);
            this._columnNamesToIndex = this.parseColumnNames(csvReader);
            this.sanityCheckOfDefaultBrowserDefinition();
        }

        public boolean hasNext() {
            if (this._hasNext == null) {
                try {
                    this._next = this._csvReader.readNext();
                    this._hasNext = this._next != null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read next line from " + this._csvReader + ".", e);
                }
                if (this._hasNext.booleanValue() && this._next.length != this._columnNamesToIndex.size()) {
                    throw new IllegalArgumentException(this._csvReader + " contains an invalid format.");
                }
            }
            return this._hasNext;
        }

        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row plainBrowserDefinition = new Row(Arrays.asList(this._next), this._columnNamesToIndex);
            this._hasNext = null;
            this._next = null;
            return plainBrowserDefinition;
        }

        long getVersion() {
            return this._version;
        }

        Date getDate() {
            return this._date;
        }

        Set<String> getColumnNames() {
            return this._columnNamesToIndex.keySet();
        }

        public void close() {
            IOUtils.closeQuietly((Closeable)this._csvReader);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        private Map<String, Integer> parseColumnNames(@Nonnull CSVReader csvReader) throws IOException {
            HashMap<String, Integer> columnNamesToIndex = new HashMap<String, Integer>();
            String[] columns = csvReader.readNext();
            for (int index = 0; index < columns.length; ++index) {
                columnNamesToIndex.put(columns[index], index);
            }
            return Collections.unmodifiableMap(columnNamesToIndex);
        }

        private void sanityCheckOfHeaderLines(@Nonnull CSVReader csvReader) throws IOException {
            String[] columns = csvReader.readNext();
            if (columns.length != 2 || !BrowserDefinitionParser.EXPECTED_FIRST_COLUMNS_CONTENT.equals(columns[0]) || !BrowserDefinitionParser.EXPECTED_FIRST_COLUMNS_CONTENT.equals(columns[1])) {
                throw new IllegalArgumentException(csvReader + " contains an invalid format.");
            }
            String[] secondColumns = csvReader.readNext();
            if (secondColumns.length != 2) {
                throw new IllegalArgumentException(csvReader + " contains an invalid format.");
            }
            this._next = secondColumns;
        }

        private void sanityCheckOfDefaultBrowserDefinition() {
            if (!this.hasNext()) {
                throw new IllegalArgumentException(this._csvReader + " contains an invalid format.");
            }
            Row next = this.next();
            if (!(BrowserDefinitionParser.DEFAULT_PROPERTIES_CONTENT.equals(next.getValue("Parent")) && BrowserDefinitionParser.DEFAULT_PROPERTIES_CONTENT.equals(next.getValue("Browser")) && BrowserDefinitionParser.DEFAULT_PROPERTIES_CONTENT.equals(next.getValue("PropertyName")))) {
                throw new IllegalArgumentException(this._csvReader + " contains an invalid format.");
            }
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

