/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.client;

import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.echocat.jomon.net.http.client.HttpClientAuth;
import org.echocat.jomon.net.http.client.HttpClientUtils;
import org.echocat.jomon.runtime.util.Duration;

public class HttpClientFactory {
    private HttpHost _proxy;
    private ClientConnectionManager _connectionManager = new PoolingClientConnectionManager();
    private boolean _acceptAllCertificates;
    private Iterable<HttpClientAuth> _auths;
    private Duration _connectionTimeout = new Duration("5s");
    private Duration _soTimeout = new Duration("1m");
    private boolean _soReuseAddress;

    public HttpHost getProxy() {
        return this._proxy;
    }

    public void setProxy(HttpHost proxy) {
        this._proxy = proxy;
    }

    public void setProxyUri(URI uri) {
        this._proxy = uri != null ? HttpClientUtils.toHttpHost(uri) : null;
    }

    public ClientConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public void setConnectionManager(ClientConnectionManager connectionManager) {
        this._connectionManager = connectionManager;
    }

    public boolean isAcceptAllCertificates() {
        return this._acceptAllCertificates;
    }

    public void setAcceptAllCertificates(boolean acceptAllCertificates) {
        this._acceptAllCertificates = acceptAllCertificates;
    }

    public Iterable<HttpClientAuth> getAuths() {
        return this._auths;
    }

    public void setAuths(Iterable<HttpClientAuth> auths) {
        this._auths = auths;
    }

    public Duration getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    public Duration getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(Duration soTimeout) {
        this._soTimeout = soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this._soReuseAddress;
    }

    public void setSoReuseAddress(boolean soReuseAddress) {
        this._soReuseAddress = soReuseAddress;
    }

    @Nonnull
    public HttpClient create() throws Exception {
        DefaultHttpClientImpl client = new DefaultHttpClientImpl(this._connectionManager, null);
        HttpHost proxy = this._proxy;
        if (proxy != null) {
            this.configureProxy((HttpClient)client, proxy);
        }
        if (this._acceptAllCertificates) {
            this.acceptAllCertificatesOf((HttpClient)client);
        }
        this.configureAuth(client, this._auths);
        this.configureTimes((HttpClient)client, this._connectionTimeout, this._soTimeout, this._soReuseAddress);
        return client;
    }

    protected void configureProxy(@Nonnull HttpClient client, @Nonnull HttpHost proxy) {
        client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    protected void acceptAllCertificatesOf(@Nonnull HttpClient client) throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{new X509TrustManagerImpl()}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
    }

    protected void configureAuth(@Nonnull DefaultHttpClientImpl client, @Nullable Iterable<HttpClientAuth> scopeAndCredentials) {
        BasicAuthCache authCache = new BasicAuthCache();
        if (scopeAndCredentials != null) {
            for (HttpClientAuth auth : scopeAndCredentials) {
                AuthScope authScope = auth.getScope();
                client.getCredentialsProvider().setCredentials(authScope, auth.getCredentials());
                authCache.put(auth.getHost(), auth.getScheme());
            }
        }
        client.setAuthCache((AuthCache)authCache);
    }

    private void configureTimes(@Nonnull HttpClient client, @Nonnull Duration connectionTimeout, @Nonnull Duration soTimeout, boolean soReuseAddress) {
        HttpParams params = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)((int)connectionTimeout.in(TimeUnit.MILLISECONDS)));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)((int)soTimeout.in(TimeUnit.MILLISECONDS)));
        HttpConnectionParams.setSoReuseaddr((HttpParams)params, (boolean)soReuseAddress);
    }

    protected class DefaultHttpClientImpl
    extends DefaultHttpClient {
        private AuthCache _authCache;

        public DefaultHttpClientImpl(@Nullable ClientConnectionManager conman, HttpParams params) {
            super(conman, params);
        }

        public AuthCache getAuthCache() {
            return this._authCache;
        }

        public void setAuthCache(AuthCache authCache) {
            this._authCache = authCache;
        }

        protected HttpContext createHttpContext() {
            HttpContext context = super.createHttpContext();
            AuthCache authCache = this._authCache;
            if (authCache != null) {
                context.setAttribute("http.auth.auth-cache", (Object)authCache);
            }
            return context;
        }
    }

    protected class X509TrustManagerImpl
    implements X509TrustManager {
        protected X509TrustManagerImpl() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

