/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.net.http.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;

public class HttpClientUtils {
    @Nonnull
    public static HttpHost toHttpHost(@Nonnull URL host) {
        try {
            return HttpClientUtils.toHttpHost(host.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not transform " + host + " to an valid uri.", e);
        }
    }

    @Nonnull
    public static HttpHost toHttpHost(@Nonnull URI host) {
        int port;
        String scheme = host.getScheme();
        int plainPort = host.getPort();
        if (plainPort >= 0) {
            port = plainPort;
        } else if ("https".equals(scheme)) {
            port = 443;
        } else if ("http".equals(scheme)) {
            port = 80;
        } else {
            throw new IllegalArgumentException("Illegal proxy uri provided: " + host);
        }
        return new HttpHost(host.getHost(), port, scheme);
    }

    private HttpClientUtils() {
    }

    @Nonnull
    public static AuthScope toAuthScope(@Nonnull URI host) {
        return HttpClientUtils.toAuthScope(HttpClientUtils.toHttpHost(host));
    }

    @Nonnull
    public static AuthScope toAuthScope(@Nonnull HttpHost host) {
        return new AuthScope(host.getHostName(), host.getPort());
    }
}

