/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.ProcessUtils;
import org.echocat.jomon.runtime.generation.Requirement;

public abstract class BaseGeneratedProcessRequirement<E, T extends BaseGeneratedProcessRequirement<E, T>>
implements Requirement {
    @Nonnull
    private final Map<String, String> _environment = new HashMap<String, String>();
    @Nonnull
    private final List<String> _arguments = new ArrayList<String>();
    @Nonnull
    private final E _executable;
    @Nullable
    private E _workingDirectory;
    private boolean _daemon;

    public BaseGeneratedProcessRequirement(@Nonnull E executable) {
        this._executable = executable;
    }

    @Nonnull
    public T withArgument(@Nonnull String argument) {
        return this.withArguments(argument);
    }

    @Nonnull
    public T withArguments(String ... arguments) {
        return this.withArguments(Arrays.asList(arguments));
    }

    @Nonnull
    public T withArguments(@Nonnull Iterable<String> arguments) {
        for (String argument : arguments) {
            this._arguments.add(argument);
        }
        return this.thisObject();
    }

    @Nonnull
    public T withWorkingDirectory(@Nonnull E workingDirectory) {
        this._workingDirectory = workingDirectory;
        return this.thisObject();
    }

    @Nonnull
    public T withEnvironment(@Nonnull String key, @Nonnull String value) {
        this._environment.put(key, value);
        return this.thisObject();
    }

    @Nonnull
    public T withEnvironment(@Nonnull Map<String, String> environment) {
        this._environment.putAll(environment);
        return this.thisObject();
    }

    @Nonnull
    public T whichIsDaemon() {
        return this.whichIsDaemon(true);
    }

    @Nonnull
    public T whichIsNoDaemon() {
        return this.whichIsDaemon(false);
    }

    @Nonnull
    public T whichIsDaemon(boolean daemon) {
        this._daemon = daemon;
        return this.thisObject();
    }

    @Nonnull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this._environment);
    }

    @Nonnull
    public List<String> getArguments() {
        return Collections.unmodifiableList(this._arguments);
    }

    @Nonnull
    public E getExecutable() {
        return this._executable;
    }

    @Nullable
    public E getWorkingDirectory() {
        return this._workingDirectory;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    @Nonnull
    public List<String> getCompleteCommandLine() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getExecutable().toString());
        command.addAll(this.getArguments());
        return Collections.unmodifiableList(command);
    }

    @Nonnull
    public String getCompleteCommandLineAsString() {
        return ProcessUtils.toEscapedCommandLine(this.getCompleteCommandLine());
    }

    @Nonnull
    protected T thisObject() {
        return (T)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Execute ").append(this.isDaemon() ? "daemon" : "process").append(' ');
        E workingDirectory = this.getWorkingDirectory();
        if (workingDirectory != null) {
            sb.append("in '").append(workingDirectory).append("' ");
        }
        sb.append(this.getCompleteCommandLineAsString());
        sb.append(" with environment ").append(this.getEnvironment());
        return sb.toString();
    }
}

