/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.echocat.jomon.runtime.CollectionUtils;

public class ProcessUtils {
    private static final Pattern ESCAPED_ARGUMENT_PATTERN = Pattern.compile("([\\s\"'])");

    @Nonnull
    public static String toEscapedCommandLine(@Nonnull String[] commandLine) {
        return ProcessUtils.toEscapedCommandLine(CollectionUtils.asImmutableList((Object[])commandLine));
    }

    @Nonnull
    public static String toEscapedCommandLine(@Nonnull Iterable<String> commandLine) {
        StringBuilder sb = new StringBuilder();
        for (String argument : commandLine) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (ESCAPED_ARGUMENT_PATTERN.matcher(argument).matches()) {
                sb.append('\"').append(ESCAPED_ARGUMENT_PATTERN.matcher(argument).replaceAll("\\$1")).append('\"');
                continue;
            }
            sb.append(argument);
        }
        return sb.toString();
    }

    @Nonnull
    public static String toEscapedCommandLine(@Nonnull Object executable, @Nullable Iterable<String> arguments) {
        String argumentsAsString;
        StringBuilder sb = new StringBuilder();
        sb.append(executable);
        String string = argumentsAsString = arguments != null ? ProcessUtils.toEscapedCommandLine(arguments) : null;
        if (!StringUtils.isEmpty((CharSequence)argumentsAsString)) {
            sb.append(' ').append(argumentsAsString);
        }
        return sb.toString();
    }

    @Nonnull
    public static String toEscapedCommandLine(@Nonnull Object executable, String ... arguments) {
        return ProcessUtils.toEscapedCommandLine(executable, CollectionUtils.asImmutableList((Object[])arguments));
    }

    private ProcessUtils() {
    }
}

