/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface Pty {
    @Nonnegative
    public int getCharacterWidth();

    @Nonnegative
    public int getCharacterHeight();

    @Nonnegative
    public int getPixelWidth();

    @Nonnegative
    public int getPixelHeight();

    @Nonnull
    public String getType();

    public static class Builder
    implements Pty {
        @Nonnegative
        private int _characterWidth = 80;
        @Nonnegative
        private int _characterHeight = 40;
        @Nonnegative
        private int _pixelWidth = 640;
        @Nonnegative
        private int _pixelHeight = 480;
        @Nonnull
        private String _type = "vt100";

        @Nonnull
        public static Builder pty() {
            return new Builder();
        }

        @Nonnull
        public static Pty ptyOfType(@Nonnull String type) {
            return Builder.pty().withType(type);
        }

        @Nonnull
        public Builder withCharacterWidth(@Nonnegative int value) {
            this._characterWidth = value;
            return this;
        }

        @Nonnull
        public Builder withCharacterHeight(@Nonnegative int value) {
            this._characterHeight = value;
            return this;
        }

        @Nonnull
        public Builder withPixelWidth(@Nonnegative int value) {
            this._pixelWidth = value;
            return this;
        }

        @Nonnull
        public Builder withPixelHeight(@Nonnegative int value) {
            this._pixelHeight = value;
            return this;
        }

        @Nonnull
        public Builder withType(@Nonnull String type) {
            this._type = type;
            return this;
        }

        @Override
        @Nonnegative
        public int getCharacterWidth() {
            return this._characterWidth;
        }

        public void setCharacterWidth(@Nonnegative int characterWidth) {
            this._characterWidth = characterWidth;
        }

        @Override
        @Nonnegative
        public int getCharacterHeight() {
            return this._characterHeight;
        }

        public void setCharacterHeight(@Nonnegative int characterHeight) {
            this._characterHeight = characterHeight;
        }

        @Override
        @Nonnegative
        public int getPixelWidth() {
            return this._pixelWidth;
        }

        public void setPixelWidth(@Nonnegative int pixelWidth) {
            this._pixelWidth = pixelWidth;
        }

        @Override
        @Nonnegative
        public int getPixelHeight() {
            return this._pixelHeight;
        }

        public void setPixelHeight(@Nonnegative int pixelHeight) {
            this._pixelHeight = pixelHeight;
        }

        @Override
        @Nonnull
        public String getType() {
            return this._type;
        }

        public void setType(@Nonnull String type) {
            this._type = type;
        }

        public String toString() {
            return this._type + "(characters: " + this._characterWidth + "x" + this._characterHeight + ", pixels: " + this._pixelWidth + "x" + this._pixelHeight + ")";
        }
    }
}

