/*
 * Decompiled with CFR 0.152.
 */
package org.echocat.jomon.process.daemon;

import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.echocat.jomon.process.daemon.ProcessDaemon;
import org.echocat.jomon.runtime.CollectionUtils;
import org.echocat.jomon.runtime.iterators.CloseableIterator;
import org.echocat.jomon.runtime.repository.Query;

public abstract class BaseProcessDaemonQuery<E, ID, Q extends BaseProcessDaemonQuery<E, ID, Q, ? extends D>, D extends ProcessDaemon<E, ID, ?, ?, ?>>
implements Query,
Predicate<D> {
    @Nullable
    private ID _pid;
    @Nullable
    private E _executable;
    @Nullable
    private Class<? extends D> _type;
    @Nullable
    private Boolean _isAlive;
    @Nullable
    private List<String> _firstArguments;

    @Nonnull
    public Q withPid(@Nonnull ID pid) {
        if (this._pid != null) {
            throw new IllegalStateException("pid was already defined.");
        }
        this._pid = pid;
        return this.thisQuery();
    }

    @Nonnull
    public Q withExecutable(@Nonnull E executable) {
        if (this._executable != null) {
            throw new IllegalStateException("executable was already defined.");
        }
        this._executable = executable;
        return this.thisQuery();
    }

    @Nonnull
    public Q whichIsOfType(@Nonnull Class<? extends D> type) {
        if (this._type != null) {
            throw new IllegalStateException("executable was already defined.");
        }
        this._type = type;
        return this.thisQuery();
    }

    @Nonnull
    public Q whichIsAlive() {
        return this.whichIsAlive(true);
    }

    @Nonnull
    public Q whichIsNotAlive() {
        return this.whichIsAlive(false);
    }

    @Nonnull
    public Q whichIsAlive(boolean alive) {
        if (this._isAlive != null) {
            throw new IllegalStateException("isAlive was already defined.");
        }
        this._isAlive = alive;
        return this.thisQuery();
    }

    @Nonnull
    public Q whichStartsWithArguments(@Nullable Iterable<String> firstArguments) {
        if (this._firstArguments != null) {
            throw new IllegalStateException("firstArguments was already defined.");
        }
        this._firstArguments = CollectionUtils.asImmutableList(firstArguments);
        return this.thisQuery();
    }

    @Nonnull
    public Q whichStartsWithArguments(String ... firstArguments) {
        if (this._firstArguments != null) {
            throw new IllegalStateException("firstArguments was already defined.");
        }
        this._firstArguments = CollectionUtils.asImmutableList((Object[])firstArguments);
        return this.thisQuery();
    }

    @Nonnull
    public Q whichStartsWithArgument(@Nonnull String firstArgument) {
        return this.whichStartsWithArguments(firstArgument);
    }

    @Nullable
    public ID getPid() {
        return this._pid;
    }

    @Nullable
    public E getExecutable() {
        return this._executable;
    }

    @Nullable
    public Class<? extends D> getType() {
        return this._type;
    }

    @Nullable
    public Boolean getAlive() {
        return this._isAlive;
    }

    @Nullable
    public List<String> getFirstArguments() {
        return this._firstArguments;
    }

    public boolean apply(@Nullable D daemon) {
        return daemon != null && this.applyPid(daemon) && this.applyExecutable(daemon) && this.applyType(daemon) && this.applyIsAlive(daemon) && this.applyFirstArguments(daemon);
    }

    protected boolean applyPid(@Nonnull D daemon) {
        return this._pid == null || this._pid.equals(((ProcessDaemon)daemon).getProcess().getId());
    }

    protected boolean applyExecutable(@Nonnull D daemon) {
        return this._executable == null || this._executable.equals(((ProcessDaemon)daemon).getProcess().getExecutable());
    }

    protected boolean applyType(@Nonnull D daemon) {
        return this._type == null || this._type.isInstance(daemon);
    }

    protected boolean applyIsAlive(@Nonnull D daemon) {
        return this._isAlive == null || this._isAlive.equals(((ProcessDaemon)daemon).getProcess().isAlive());
    }

    protected boolean applyFirstArguments(@Nonnull D daemon) {
        boolean result;
        List<String> firstArguments = this._firstArguments;
        if (firstArguments == null || firstArguments.isEmpty()) {
            result = true;
        } else {
            List<String> commandLine = ((ProcessDaemon)daemon).getProcess().getArguments();
            if (firstArguments.size() <= commandLine.size() + 1) {
                Iterator<String> ei = firstArguments.iterator();
                CloseableIterator et = CollectionUtils.asIterator(commandLine);
                if (et.hasNext()) {
                    result = true;
                    et.next();
                    while (result && ei.hasNext() && et.hasNext()) {
                        result = ei.next().equals(et.next());
                    }
                    if (result && !et.hasNext()) {
                        result = !ei.hasNext();
                    }
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    @Nonnull
    protected Q thisQuery() {
        return (Q)this;
    }
}

